/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view;

import com.intel.stl.api.management.IAttribute;
import com.intel.stl.ui.admin.impl.IRendererModel;
import com.intel.stl.ui.admin.view.IAttrRenderer;
import com.intel.stl.ui.common.ExComboBoxModel;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ExComboBox;
import com.intel.stl.ui.common.view.IntelComboBoxUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;

public abstract class AbstractAttrPanel
extends JPanel {
    private static final long serialVersionUID = 8015988954981766653L;
    private static final String INIT = "init";
    private static final String STARTED = "started";
    private JPanel namePanel;
    private JPanel editorPanel;
    protected ExComboBox<String> typeList;
    protected JButton removeBtn;
    protected IRendererModel rendererModel;
    protected String currentRendererName;
    protected IAttrRenderer<? extends IAttribute> currentRenderer;

    public AbstractAttrPanel(IRendererModel rendererModel) {
        this.rendererModel = rendererModel;
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new BorderLayout(5, 5));
        this.setOpaque(false);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY, 1, true), BorderFactory.createEmptyBorder(2, 5, 2, 2)));
        this.editorPanel = new JPanel(new BorderLayout());
        this.editorPanel.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY));
        this.add((Component)this.editorPanel, "Center");
        ExComboBoxModel<String> comboModel = new ExComboBoxModel<String>(this.rendererModel.getRendererNames(), false);
        final CompoundBorder rendererBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, UIConstants.INTEL_GRAY), BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.typeList = new ExComboBox<String>(comboModel){
            private static final long serialVersionUID = 826992741561960993L;

            @Override
            protected void decorateDisabledCell(JLabel label, boolean isDisabled, int index) {
                label.setIcon(isDisabled ? UIImages.UNEDITABLE.getImageIcon() : null);
                if (index == -1) {
                    label.setBorder(rendererBorder);
                }
            }
        };
        this.typeList.setDisabledColor(UIConstants.INTEL_LIGHT_GRAY);
        IntelComboBoxUI ui = new IntelComboBoxUI();
        this.typeList.setUI(ui);
        this.typeList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String old = AbstractAttrPanel.this.currentRendererName;
                if (AbstractAttrPanel.this.currentRenderer != null) {
                    AbstractAttrPanel.this.remove(AbstractAttrPanel.this.currentRenderer.getView());
                } else {
                    AbstractAttrPanel.this.remove(AbstractAttrPanel.this.editorPanel);
                }
                IAttrRenderer<? extends IAttribute> renderer = AbstractAttrPanel.this.getAttrRenderer();
                JComponent view = null;
                if (renderer != null) {
                    view = renderer.getView();
                }
                AbstractAttrPanel.this.add((Component)view, "Center");
                if (!AbstractAttrPanel.this.removeBtn.isEnabled()) {
                    AbstractAttrPanel.this.removeBtn.setEnabled(true);
                }
                AbstractAttrPanel.this.revalidate();
                AbstractAttrPanel.this.repaint();
                if (old != null) {
                    AbstractAttrPanel.this.onChangeRenderer(old, AbstractAttrPanel.this.currentRendererName);
                }
            }
        });
        JLabel hintLabel = ComponentFactory.getH4Label(STLConstants.K2117_SEL_ATTR_TYPE.getValue(), 1);
        hintLabel.setForeground(UIConstants.INTEL_BLUE);
        hintLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        hintLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ExComboBoxModel comboModel = (ExComboBoxModel)AbstractAttrPanel.this.typeList.getModel();
                String toSelect = (String)comboModel.getFirstAvailableItem();
                if (toSelect != null) {
                    ((CardLayout)AbstractAttrPanel.this.namePanel.getLayout()).show(AbstractAttrPanel.this.namePanel, AbstractAttrPanel.STARTED);
                    AbstractAttrPanel.this.typeList.setSelectedItem(toSelect);
                    AbstractAttrPanel.this.onAddAttr();
                }
            }
        });
        this.namePanel = new JPanel(new CardLayout());
        this.namePanel.add((Component)hintLabel, INIT);
        this.namePanel.add(this.typeList, STARTED);
        this.add((Component)this.namePanel, "West");
        this.removeBtn = ComponentFactory.getImageButton(UIImages.CLOSE_GRAY.getImageIcon());
        this.removeBtn.setEnabled(false);
        this.removeBtn.setRolloverEnabled(true);
        this.removeBtn.setRolloverIcon(UIImages.CLOSE_RED.getImageIcon());
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAttrPanel.this.onRemoveAttr();
            }
        });
        this.add((Component)this.removeBtn, "East");
    }

    public IAttrRenderer<? extends IAttribute> getAttrRenderer() {
        String name = (String)this.typeList.getSelectedItem();
        if (!name.equals(this.currentRendererName)) {
            this.currentRendererName = name;
            try {
                if (this.rendererModel != null) {
                    this.currentRenderer = this.rendererModel.getRenderer(name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.currentRenderer = null;
            }
        }
        return this.currentRenderer;
    }

    public String getRendererName() {
        return (String)this.typeList.getSelectedItem();
    }

    public <E extends IAttribute> void setAttr(String type, E attr, boolean isEditable) {
        this.typeList.setSelectedItem(type);
        IAttrRenderer<? extends IAttribute> renderer = this.getAttrRenderer();
        if (renderer != null) {
            renderer.setAttr(attr);
            renderer.setEditable(isEditable);
        }
        this.typeList.setEnabled(isEditable);
        ((CardLayout)this.namePanel.getLayout()).show(this.namePanel, STARTED);
        this.removeBtn.setEnabled(isEditable);
    }

    protected abstract void onAddAttr();

    protected abstract void onRemoveAttr();

    protected abstract void onChangeRenderer(String var1, String var2);
}

