/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view;

import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.FieldPair;
import com.intel.stl.ui.common.view.SafeNumberField;
import com.intel.stl.ui.common.view.SafeTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;

public class DeployHostPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 2530929163645777773L;
    private JCheckBox selectBox;
    private SafeTextField hostField;
    private SafeNumberField<Integer> portField;
    private SafeTextField userField;
    private JPasswordField passwordField;
    private JLabel stateLabel;
    private JLabel msgLabel;
    private ActionListener removeAction;
    private DeployState state;

    public DeployHostPanel() {
        this((HostInfo)null);
    }

    public DeployHostPanel(HostInfo hostInfo) {
        this.initComponent();
        if (hostInfo != null) {
            this.setHost(hostInfo.getHost());
            this.setPort(hostInfo.getSshPortNum());
            this.setUser(hostInfo.getSshUserName());
        }
    }

    protected void initComponent() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.fill = 2;
        gc.gridwidth = 1;
        this.selectBox = ComponentFactory.getIntelCheckBox("");
        this.selectBox.setSelected(true);
        this.selectBox.setName(WidgetName.ADMIN_VF_DEPLOY_SELECT_BOX.name());
        this.add((Component)this.selectBox, gc);
        gc.weightx = 1.0;
        JPanel panel = new JPanel(new GridLayout(1, 4));
        panel.setOpaque(false);
        panel.add(this.getHostField());
        panel.add(this.getPortField());
        panel.add(this.getUserField());
        panel.add(this.getPasswordField());
        this.add((Component)panel, gc);
        gc.weightx = 0.0;
        gc.gridwidth = 0;
        this.stateLabel = new JLabel();
        this.stateLabel.addMouseListener(this);
        this.stateLabel.setName(WidgetName.ADMIN_VF_DEPLOY_STATE_ICON.name());
        this.add((Component)this.stateLabel, gc);
        gc.weightx = 1.0;
        this.msgLabel = ComponentFactory.getH5Label("", 0);
        this.msgLabel.setForeground(UIConstants.INTEL_DARK_ORANGE);
        this.msgLabel.setName(WidgetName.ADMIN_VF_DEPLOY_STATE_MESSAGE.name());
        this.add((Component)this.msgLabel, gc);
    }

    protected FieldPair<?> getHostField() {
        String hostNameChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqsrtuvwxyz-.";
        this.hostField = new SafeTextField(false, 253);
        this.hostField.setValidChars(hostNameChars);
        this.hostField.setName(WidgetName.ADMIN_VF_DEPLOY_HOST.name());
        return new FieldPair<SafeTextField>(STLConstants.K0051_HOST.getValue(), this.hostField);
    }

    protected FieldPair<?> getPortField() {
        this.portField = new SafeNumberField<Integer>(new DecimalFormat("###"), 0, false, 65535, false);
        this.portField.setValidChars("0123456789");
        this.portField.setText("22");
        this.portField.setName(WidgetName.ADMIN_VF_DEPLOY_PORT_NUMBER.name());
        return new FieldPair<SafeNumberField<Integer>>(STLConstants.K0427_PORT_NUMBER.getValue(), this.portField);
    }

    protected FieldPair<?> getUserField() {
        this.userField = new SafeTextField(false, 32);
        this.userField.setName(WidgetName.ADMIN_VF_DEPLOY_USER_NAME.name());
        return new FieldPair<SafeTextField>(STLConstants.K0602_USER_NAME.getValue(), this.userField);
    }

    protected FieldPair<?> getPasswordField() {
        this.passwordField = ComponentFactory.createPasswordField(null);
        this.passwordField.setName(WidgetName.ADMIN_VF_DEPLOY_PASSWORD.name());
        return new FieldPair<JPasswordField>(STLConstants.K1049_PASSWORD.getValue(), this.passwordField);
    }

    public void setHostInfo(HostInfo hostInfo) {
        if (hostInfo != null) {
            this.msgLabel.setText(null);
            this.setHost(hostInfo.getHost());
            this.setPort(hostInfo.getSshPortNum());
            this.setUser(hostInfo.getSshUserName());
        }
    }

    public HostInfo getHostInfo() {
        HostInfo res = new HostInfo();
        res.setHost(this.getHost());
        res.setSshPortNum(Integer.parseInt(this.getPort()));
        res.setSshUserName(this.getUser());
        return res;
    }

    public void setHost(String name) {
        this.hostField.setText(name);
    }

    public String getHost() {
        return this.hostField.getText();
    }

    public void setPort(int port) {
        this.portField.setText(Integer.toString(port));
    }

    public String getPort() {
        return this.portField.getText();
    }

    public void setUser(String name) {
        this.userField.setText(name);
    }

    public String getUser() {
        return this.userField.getText();
    }

    public void setPassword(char[] password) {
        this.passwordField.setText(new String(password));
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public void addPasswordDocListener(DocumentListener listener) {
        this.passwordField.getDocument().addDocumentListener(listener);
    }

    public void removePasswordDocListener(DocumentListener listener) {
        this.passwordField.getDocument().removeDocumentListener(listener);
    }

    public void addUserDocListener(DocumentListener listener) {
        this.userField.getDocument().addDocumentListener(listener);
    }

    public void removeUserDocListener(DocumentListener listener) {
        this.userField.getDocument().removeDocumentListener(listener);
    }

    public void clearPassword() {
        DocumentListener[] listeners;
        for (DocumentListener listener : listeners = ((AbstractDocument)this.passwordField.getDocument()).getDocumentListeners()) {
            this.passwordField.getDocument().removeDocumentListener(listener);
        }
        this.passwordField.setText(null);
        for (DocumentListener listener : listeners) {
            this.passwordField.getDocument().addDocumentListener(listener);
        }
    }

    public void setState(DeployState state) {
        this.state = state;
        this.stateLabel.setIcon(state.getIcon());
        if (state == DeployState.RUNNING) {
            this.msgLabel.setText(null);
        }
        this.selectBox.setSelected(state != DeployState.SUCCESS);
    }

    public DeployState getState() {
        return this.state;
    }

    public void setErrorMessage(String msg) {
        this.setState(DeployState.ERROR);
        this.msgLabel.setText(msg);
    }

    public void setRemoveAction(ActionListener listener) {
        this.removeAction = listener;
    }

    public boolean isSelected() {
        return this.selectBox.isSelected();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.removeAction != null) {
            this.removeAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.paramString()));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.state != DeployState.SUCCESS && this.state != DeployState.RUNNING) {
            this.stateLabel.setIcon(UIImages.CLOSE_RED.getImageIcon());
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.state != DeployState.SUCCESS && this.state != DeployState.RUNNING) {
            this.stateLabel.setIcon(this.state.getIcon());
        }
    }

    public static enum DeployState {
        NONE(null),
        EDIT(UIImages.CLOSE_GRAY.getImageIcon()),
        RUNNING(UIImages.RUNNING.getImageIcon()),
        ERROR(UIImages.WARNING_ICON.getImageIcon()),
        SUCCESS(UIImages.CHECK_MARK.getImageIcon());

        private Icon icon;

        private DeployState(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

