/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view;

import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.admin.view.DeployHostPanel;
import com.intel.stl.ui.admin.view.IDeployListener;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.VerticalLayout;

public class DeployPanel
extends JPanel {
    private static final long serialVersionUID = -7256068752960371918L;
    private DeployHostPanel masterSM;
    private JCheckBox sameCredential;
    private JScrollPane smsScrollPane;
    private JPanel standbySMsPanel;
    private JLabel addBtn;
    private JButton deployBtn;
    private JButton backBtn;
    private final List<DeployHostPanel> otherSMs = new ArrayList<DeployHostPanel>();
    private IDeployListener listener;
    private DocumentListener passwordListener;
    private DocumentListener userListener;

    public DeployPanel() {
        this.setBackground(UIConstants.INTEL_WHITE);
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 0;
        gc.insets = new Insets(20, 2, 20, 2);
        JLabel label = ComponentFactory.getH2Label(UILabels.STL81110_DEPLOY_MSG.getDescription(), 2);
        label.setHorizontalAlignment(0);
        label.setForeground(UIConstants.INTEL_BLUE);
        this.add((Component)label, gc);
        label = ComponentFactory.getH3Label(STLConstants.K0025_MASTER_SM.getValue(), 1);
        this.add((Component)label, gc);
        int indent = 25;
        gc.insets = new Insets(2, indent, 2, 2);
        this.masterSM = new DeployHostPanel();
        this.masterSM.addPasswordDocListener(this.getPasswordListener());
        this.masterSM.addUserDocListener(this.getUserListener());
        this.add((Component)this.masterSM, gc);
        gc.fill = 0;
        gc.anchor = 13;
        this.sameCredential = ComponentFactory.getIntelCheckBox(UILabels.STL81113_APPLY_CREDENTIAL.getDescription());
        this.sameCredential.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployPanel.this.masterSM.removePasswordDocListener(DeployPanel.this.getPasswordListener());
                DeployPanel.this.masterSM.removeUserDocListener(DeployPanel.this.getUserListener());
                if (DeployPanel.this.sameCredential.isSelected()) {
                    DeployPanel.this.applyCredential();
                    DeployPanel.this.masterSM.addPasswordDocListener(DeployPanel.this.getPasswordListener());
                    DeployPanel.this.masterSM.addUserDocListener(DeployPanel.this.getUserListener());
                }
            }
        });
        this.sameCredential.setSelected(true);
        this.sameCredential.setName(WidgetName.ADMIN_VF_DEPLOY_SAME_CREDENTIAL.name());
        this.add((Component)this.sameCredential, gc);
        gc.insets = new Insets(2, 2, 2, 2);
        gc.fill = 2;
        label = ComponentFactory.getH3Label(STLConstants.K0059_STANDBY_SMS.getValue(), 1);
        this.add((Component)label, gc);
        gc.insets = new Insets(2, indent, 2, 2);
        this.standbySMsPanel = new JPanel((LayoutManager)new VerticalLayout());
        this.standbySMsPanel.setBackground(UIConstants.INTEL_WHITE);
        this.standbySMsPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 7));
        this.standbySMsPanel.setName(WidgetName.ADMIN_VF_DEPLOY_STANDBY_SMS.name());
        this.smsScrollPane = new JScrollPane(this.standbySMsPanel);
        this.smsScrollPane.setPreferredSize(new Dimension(400, 400));
        this.add((Component)this.smsScrollPane, gc);
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 17;
        this.addBtn = ComponentFactory.getH3Label(UILabels.STL81114_ADD_SM.getDescription(), 0);
        this.addBtn.setForeground(UIConstants.INTEL_BLUE);
        final Border border1 = BorderFactory.createEmptyBorder(2, 4, 3, 4);
        final CompoundBorder border2 = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIConstants.INTEL_GRAY), BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.addBtn.setBorder(border1);
        this.addBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DeployPanel.this.addHostEntry(null);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DeployPanel.this.addBtn.setBorder(border2);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DeployPanel.this.addBtn.setBorder(border1);
            }
        });
        this.addBtn.setName(WidgetName.ADMIN_VF_DEPLOY_ADD_NEW_STANDBY_SM.name());
        this.add((Component)this.addBtn, gc);
        gc.anchor = 13;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        this.deployBtn = ComponentFactory.getIntelActionButton(STLConstants.K2131_DEPLOY.getValue());
        this.deployBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeployPanel.this.deployBtn.getText().equals(STLConstants.K2131_DEPLOY.getValue())) {
                    if (DeployPanel.this.listener != null) {
                        DeployPanel.this.listener.onDeploy(DeployPanel.this.masterSM, DeployPanel.this.otherSMs);
                        DeployPanel.this.deployBtn.setText(STLConstants.K0621_CANCEL.getValue());
                        DeployPanel.this.backBtn.setEnabled(false);
                    }
                } else if (DeployPanel.this.listener != null) {
                    DeployPanel.this.listener.onCancel();
                }
            }
        });
        this.deployBtn.setName(WidgetName.ADMIN_VF_DEPLOY_DEPLOY.name());
        panel.add(this.deployBtn);
        this.backBtn = ComponentFactory.getIntelDeleteButton(STLConstants.K0624_BACK.getValue());
        this.backBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployPanel.this.listener.onClose();
            }
        });
        this.backBtn.setName(WidgetName.ADMIN_VF_DEPLOY_BACK.name());
        panel.add(this.backBtn);
        this.add((Component)panel, gc);
    }

    protected DocumentListener getPasswordListener() {
        if (this.passwordListener == null) {
            this.passwordListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.applyPassword();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.applyPassword();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.applyPassword();
                }

                protected void applyPassword() {
                    char[] password = DeployPanel.this.masterSM.getPassword();
                    for (DeployHostPanel hp : DeployPanel.this.otherSMs) {
                        hp.setPassword(password);
                        hp.repaint();
                    }
                }
            };
        }
        return this.passwordListener;
    }

    protected DocumentListener getUserListener() {
        if (this.userListener == null) {
            this.userListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.applyUserName();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.applyUserName();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.applyUserName();
                }

                protected void applyUserName() {
                    String name = DeployPanel.this.masterSM.getUser();
                    for (DeployHostPanel hp : DeployPanel.this.otherSMs) {
                        hp.setUser(name);
                        hp.repaint();
                    }
                }
            };
        }
        return this.userListener;
    }

    public void setSubnet(SubnetDescription subnet) {
        HostInfo hostInfo = subnet.getCurrentFE();
        this.masterSM.setHostInfo(hostInfo);
        this.masterSM.setState(DeployHostPanel.DeployState.NONE);
        this.standbySMsPanel.removeAll();
        List<HostInfo> fes = subnet.getFEList();
        for (HostInfo fe : fes) {
            if (fe == hostInfo) continue;
            this.addHostEntry(fe);
        }
        this.deployBtn.setText(STLConstants.K2131_DEPLOY.getValue());
    }

    public void setDeployListener(IDeployListener listener) {
        this.listener = listener;
    }

    public void setFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeployPanel.this.deployBtn.setText(STLConstants.K2131_DEPLOY.getValue());
                DeployPanel.this.backBtn.setEnabled(true);
            }
        });
    }

    protected void applyCredential() {
        String name = this.masterSM.getUser();
        char[] password = this.masterSM.getPassword();
        for (DeployHostPanel hp : this.otherSMs) {
            hp.setUser(name);
            hp.setPassword(password);
            hp.repaint();
        }
    }

    protected void addHostEntry(HostInfo hostInfo) {
        final DeployHostPanel hp = new DeployHostPanel(hostInfo);
        hp.setRemoveAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployHostPanel.DeployState state = hp.getState();
                if (state != DeployHostPanel.DeployState.SUCCESS && state != DeployHostPanel.DeployState.RUNNING) {
                    DeployPanel.this.standbySMsPanel.remove(hp);
                    DeployPanel.this.otherSMs.remove(hp);
                    DeployPanel.this.revalidate();
                }
            }
        });
        hp.setState(DeployHostPanel.DeployState.EDIT);
        if (this.sameCredential.isSelected()) {
            String name = this.masterSM.getUser();
            char[] password = this.masterSM.getPassword();
            hp.setUser(name);
            hp.setPassword(password);
        }
        this.standbySMsPanel.add(hp);
        this.otherSMs.add(hp);
        this.revalidate();
        this.standbySMsPanel.scrollRectToVisible(hp.getBounds());
    }
}

