/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view;

import com.intel.stl.ui.admin.view.ILoginListener;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.console.LoginBean;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;

public class LoginPanel
extends JPanel {
    protected JFormattedTextField hostField;
    protected JFormattedTextField userField;
    protected JFormattedTextField portField;
    protected JPasswordField passwordField;
    private LoginBean credentials = new LoginBean();
    private JTextArea messageArea;
    protected JProgressBar progressBar;
    protected ILoginListener listener;
    private JButton cancelBtn;
    private JButton loginBtn;
    protected JPanel btnPanel;
    protected GridBagConstraints gc;
    private static final long serialVersionUID = -3922793376630351870L;

    public LoginPanel() {
        this.initLoginPanel();
    }

    public LoginPanel(ILoginListener listener) {
        this.listener = listener;
        this.initLoginPanel();
    }

    protected void initLoginPanel() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BLUE, 2), STLConstants.K1050_LOGIN.getValue(), 1, 2, UIConstants.H5_FONT.deriveFont(1)));
        this.setLayout(new GridBagLayout());
        this.gc = new GridBagConstraints();
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.gc.weightx = 1.0;
        this.gc.insets = new Insets(10, 10, 10, 10);
        this.gc.fill = 2;
        this.gc.gridwidth = 0;
        this.messageArea = this.createMessageArea();
        this.add((Component)this.messageArea, this.gc);
        int row = this.addCredentialFields(2);
        this.gc.gridx = 1;
        this.gc.gridy = row++;
        this.gc.fill = 2;
        this.gc.anchor = 10;
        this.gc.gridwidth = 0;
        this.progressBar = this.createProgressBar();
        this.add((Component)this.progressBar, this.gc);
        this.gc.gridx = 1;
        this.gc.gridy = row;
        this.gc.gridwidth = 0;
        this.gc.fill = 2;
        this.btnPanel = this.createButtonPanel();
        this.add((Component)this.btnPanel, this.gc);
        this.setBackground(UIConstants.INTEL_WHITE);
        this.setPreferredSize(new Dimension(400, 400));
    }

    protected JTextArea createMessageArea() {
        this.messageArea = new JTextArea();
        this.messageArea.setText("");
        this.messageArea.setFont(UIConstants.H5_FONT.deriveFont(0));
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setLineWrap(true);
        this.messageArea.setEditable(false);
        this.messageArea.setFocusable(false);
        return this.messageArea;
    }

    protected JProgressBar createProgressBar() {
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(false);
        return this.progressBar;
    }

    protected int addCredentialFields(int row) {
        this.gc.gridx = 0;
        this.gc.gridy = row++;
        this.gc.insets = new Insets(10, 10, 10, 10);
        this.gc.fill = 2;
        this.gc.gridwidth = 0;
        this.gc.weightx = 0.0;
        this.gc.gridwidth = 1;
        JLabel label = ComponentFactory.getH5Label(STLConstants.K0051_HOST.getValue() + " :", 1);
        label.setHorizontalAlignment(4);
        this.add((Component)label, this.gc);
        this.gc.weightx = 1.0;
        this.gc.gridwidth = 0;
        this.gc.gridx = 1;
        this.hostField = ComponentFactory.createTextField(null, true, 100, null);
        this.hostField.setText("");
        this.hostField.setEnabled(true);
        this.hostField.setEditable(false);
        this.add((Component)this.hostField, this.gc);
        this.gc.gridx = 0;
        this.gc.gridy = row++;
        this.gc.weightx = 0.0;
        this.gc.gridwidth = 1;
        label = ComponentFactory.getH5Label(STLConstants.K0404_PORT_NUMBER.getValue() + " :", 1);
        label.setHorizontalAlignment(4);
        this.add((Component)label, this.gc);
        this.gc.gridx = 1;
        this.gc.weightx = 1.0;
        this.gc.gridwidth = 0;
        this.portField = ComponentFactory.createTextField("0123456789", false, 5, null);
        this.portField.setText("22");
        this.add((Component)this.portField, this.gc);
        this.gc.weightx = 0.0;
        this.gc.gridx = 0;
        this.gc.gridy = row++;
        this.gc.gridwidth = 1;
        label = ComponentFactory.getH5Label(STLConstants.K0602_USER_NAME.getValue() + " :", 1);
        label.setHorizontalAlignment(4);
        this.add((Component)label, this.gc);
        this.gc.gridx = 1;
        this.gc.weightx = 1.0;
        this.gc.gridwidth = 0;
        this.userField = ComponentFactory.createTextField(null, true, 40, null);
        this.userField.setText("");
        this.add((Component)this.userField, this.gc);
        this.gc.weightx = 0.0;
        this.gc.gridx = 0;
        this.gc.gridy = row++;
        this.gc.gridwidth = 1;
        label = ComponentFactory.getH5Label(STLConstants.K1049_PASSWORD.getValue() + " :", 1);
        label.setHorizontalAlignment(4);
        this.add((Component)label, this.gc);
        this.gc.weightx = 1.0;
        this.gc.gridx = 1;
        this.gc.gridwidth = 0;
        this.passwordField = ComponentFactory.createPasswordField(null);
        this.passwordField.setInputVerifier(null);
        this.passwordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.loginBtnAction();
            }
        });
        this.add((Component)this.passwordField, this.gc);
        return row;
    }

    protected JPanel createButtonPanel() {
        this.cancelBtn = ComponentFactory.getIntelActionButton(STLConstants.K0621_CANCEL.getValue());
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.cancelBtnAction();
            }
        });
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new GridBagLayout());
        this.btnPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(10, 0, 10, 10);
        this.btnPanel.add((Component)this.cancelBtn, gbc);
        this.loginBtn = ComponentFactory.getIntelActionButton(STLConstants.K1050_LOGIN.getValue());
        this.loginBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.loginBtnAction();
            }
        });
        gbc.gridx = 1;
        gbc.insets = new Insets(10, 0, 10, 0);
        gbc.gridwidth = 0;
        this.btnPanel.add((Component)this.loginBtn, gbc);
        return this.btnPanel;
    }

    protected void loginBtnAction() {
        String hostName = this.hostField.getText();
        this.credentials.setHostName(hostName);
        this.credentials.setPortNum(this.portField.getText());
        this.credentials.setUserName(this.userField.getText());
        this.credentials.setPassword(this.passwordField.getPassword());
        this.setMessage("");
        if (hostName != null && !hostName.isEmpty()) {
            this.progressBar.setIndeterminate(true);
            this.listener.credentialsReady();
        } else {
            this.setMessage(STLConstants.K5004_LOGIN_ERROR_MSG.getValue());
        }
    }

    protected void cancelBtnAction() {
        this.listener.cancelLogin();
        this.progressBar.setIndeterminate(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.hostField.setEnabled(enabled);
        this.userField.setEnabled(enabled);
        this.portField.setEnabled(enabled);
        this.passwordField.setEnabled(enabled);
        this.cancelBtn.setEnabled(enabled);
        this.loginBtn.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void clearLoginData() {
        DocumentListener[] listeners;
        for (DocumentListener listener : listeners = ((AbstractDocument)this.passwordField.getDocument()).getDocumentListeners()) {
            this.passwordField.getDocument().removeDocumentListener(listener);
        }
        this.passwordField.setText("");
        this.passwordField.setCaretPosition(0);
        for (DocumentListener listener : listeners) {
            this.passwordField.getDocument().addDocumentListener(listener);
        }
        this.progressBar.setIndeterminate(false);
        this.credentials.setPassword(null);
    }

    public LoginBean getCredentials() {
        return this.credentials;
    }

    public void setCredentials(LoginBean credentials) {
        this.credentials = credentials;
    }

    public void setHostNameField(String host) {
        this.hostField.setText(host);
    }

    public void setUserNameField(String userName) {
        this.userField.setText(userName);
    }

    public void setPortNumber(String portNum) {
        this.portField.setText(portNum);
    }

    public void setMessage(String msg) {
        this.messageArea.setText(msg);
    }

    public void showProgress(boolean show) {
        this.progressBar.setIndeterminate(show);
    }

    public String getUserNameFieldStr() {
        return this.userField.getText();
    }

    public String getPortFieldStr() {
        return this.portField.getText();
    }

    public void setListener(ILoginListener listener) {
        this.listener = listener;
    }

    public void setHostFieldEditable(boolean editable) {
        this.hostField.setEditable(editable);
    }

    public void setHostFieldEnabled(boolean b) {
        this.hostField.setEnabled(b);
    }
}

