/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.ui.tabbedui.VerticalLayout;

public class NavigationPanel
extends JPanel {
    private static final long serialVersionUID = -7750864974612798171L;
    private final Map<String, IconPanel> itemMap = new LinkedHashMap<String, IconPanel>();
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();

    public NavigationPanel() {
        super((LayoutManager)new VerticalLayout());
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 10, UIConstants.INTEL_WHITE));
    }

    public void addItem(String name, Icon icon) {
        if (this.itemMap.containsKey(name)) {
            throw new IllegalArgumentException("Item '" + name + "' alreday existed.");
        }
        IconPanel panel = new IconPanel(name, icon);
        this.itemMap.put(name, panel);
        this.add(panel);
    }

    public void addSeparator(int size) {
        this.add(Box.createRigidArea(new Dimension(10, size)));
    }

    public void selectItem(String name) {
        for (Map.Entry<String, IconPanel> entry : this.itemMap.entrySet()) {
            IconPanel panel = entry.getValue();
            panel.setSelected(entry.getKey().equals(name));
        }
    }

    protected void fireSelection(String name) {
        IconPanel panel = this.itemMap.get(name);
        if (panel != null) {
            ChangeEvent event = new ChangeEvent(panel);
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(event);
            }
        }
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public class IconPanel
    extends JPanel {
        private static final long serialVersionUID = -1275114280998145382L;
        private JLabel[] nameLabels;
        private final String name;

        public IconPanel(String name, Icon image) {
            this.name = name;
            this.initializePanel(name, image);
        }

        @Override
        public String getName() {
            return this.name;
        }

        protected void initializePanel(String title, Icon image) {
            this.setLayout(new BoxLayout(this, 1));
            this.setBackground(UIConstants.INTEL_BACKGROUND_GRAY);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_GRAY), BorderFactory.createEmptyBorder(4, 2, 2, 2))));
            JLabel lblIcon = new JLabel(image);
            lblIcon.setAlignmentX(0.5f);
            this.add(lblIcon);
            String[] lines = title.split(" ");
            this.nameLabels = new JLabel[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                this.nameLabels[i] = ComponentFactory.getH4Label(lines[i], 1);
                this.nameLabels[i].setHorizontalAlignment(0);
                this.nameLabels[i].setAlignmentX(0.5f);
                this.add(this.nameLabels[i]);
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    NavigationPanel.this.fireSelection(IconPanel.this.name);
                }
            });
        }

        public void setSelected(boolean isSelected) {
            if (isSelected) {
                this.setBackground(UIConstants.INTEL_WHITE);
                for (JLabel label : this.nameLabels) {
                    label.setForeground(UIConstants.INTEL_BLUE);
                }
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 5, 1, 0, UIConstants.INTEL_BLUE), BorderFactory.createEmptyBorder(4, 2, 2, 2))));
            } else {
                this.setBackground(UIConstants.INTEL_BACKGROUND_GRAY);
                for (JLabel label : this.nameLabels) {
                    label.setForeground(UIConstants.INTEL_GRAY);
                }
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_GRAY), BorderFactory.createEmptyBorder(4, 2, 2, 2))));
            }
        }
    }
}

