/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.alert;

import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.ui.alert.EventProcesser;
import com.intel.stl.ui.framework.AbstractEvent;
import com.intel.stl.ui.framework.IAppEvent;
import java.util.Collection;
import java.util.List;
import net.engio.mbassy.bus.MBassador;

public abstract class EventBusProcessor<E extends AbstractEvent>
extends EventProcesser {
    private static final boolean DEBUG = false;
    private final MBassador<IAppEvent> eventBus;
    private final Collection<E> eventsToSend;
    private final BusWorker worker;
    private boolean toStop;

    public EventBusProcessor(MBassador<IAppEvent> eventBus) {
        this.eventBus = eventBus;
        this.setTargetTypes(this.getTargetTypes());
        this.eventsToSend = this.createBusEventCollection();
        this.worker = new BusWorker();
        this.startWorker(this.worker);
    }

    protected void startWorker(Runnable worker) {
        Thread thread = new Thread(worker);
        thread.setDaemon(true);
        thread.start();
    }

    protected abstract EventType[] getTargetTypes();

    protected abstract Collection<E> createBusEventCollection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processEvents(List<EventDescription> evts) {
        if (this.toStop) {
            return;
        }
        E event = this.toBusEvent(evts);
        Collection<E> collection = this.eventsToSend;
        synchronized (collection) {
            this.eventsToSend.add(event);
        }
    }

    protected abstract E toBusEvent(List<EventDescription> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishProcess() {
        if (this.toStop) {
            return;
        }
        BusWorker busWorker = this.worker;
        synchronized (busWorker) {
            this.worker.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        Object object = this.eventsToSend;
        synchronized (object) {
            this.eventsToSend.clear();
        }
        object = this.worker;
        synchronized (object) {
            this.worker.toStop();
            this.worker.notify();
        }
    }

    class BusWorker
    implements Runnable {
        BusWorker() {
        }

        public void toStop() {
            EventBusProcessor.this.toStop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!EventBusProcessor.this.toStop) {
                Object[] events = null;
                Object object = EventBusProcessor.this.eventsToSend;
                synchronized (object) {
                    events = EventBusProcessor.this.eventsToSend.toArray();
                    EventBusProcessor.this.eventsToSend.clear();
                }
                if (events != null && events.length > 0) {
                    for (Object event : events) {
                        EventBusProcessor.this.eventBus.publish((Object)((AbstractEvent)event));
                    }
                    continue;
                }
                object = this;
                synchronized (object) {
                    try {
                        if (!EventBusProcessor.this.toStop) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

