/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.ICardController;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import java.awt.Component;
import net.engio.mbassy.bus.MBassador;

public abstract class BaseCardController<E extends ICardListener, V extends JCardView<E>>
implements ICardController<V>,
ICardListener {
    protected E listener;
    protected V view;
    protected final MBassador<IAppEvent> eventBus;
    private String helpID;

    public BaseCardController(V view, MBassador<IAppEvent> eventBus) {
        if (view == null) {
            throw new IllegalArgumentException("View can not be null!");
        }
        this.view = view;
        this.installHelp();
        this.eventBus = eventBus;
        this.installListener();
    }

    protected void installHelp() {
        String helpId = this.getHelpID();
        if (helpId != null) {
            ((JCardView)this.view).enableHelp(true);
            HelpAction helpAction = HelpAction.getInstance();
            helpAction.getHelpBroker().enableHelpOnButton((Component)((JCardView)this.view).getHelpButton(), helpId, helpAction.getHelpSet());
        } else {
            ((JCardView)this.view).enableHelp(false);
        }
    }

    protected void installListener() {
        this.listener = this.getCardListener();
        ((JCardView)this.view).setCardListener(this.listener);
    }

    @Override
    public void clear() {
    }

    @Override
    public V getView() {
        return this.view;
    }

    @Override
    public void onPin() {
    }

    @Override
    public void onHelp() {
    }

    public abstract E getCardListener();

    public void setHelpID(String helpID) {
        this.helpID = helpID;
        this.installHelp();
    }

    @Override
    public String getHelpID() {
        return this.helpID;
    }

    @Override
    public PinDescription.PinID getPinID() {
        return null;
    }
}

