/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.ISectionController;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import java.awt.Component;
import net.engio.mbassy.bus.MBassador;

public abstract class BaseSectionController<E extends ISectionListener, V extends JSectionView<E>>
implements ISectionController<V>,
ISectionListener {
    protected E listener;
    protected V view;
    protected MBassador<IAppEvent> eventBus;
    private String helpID;

    public BaseSectionController(V view, MBassador<IAppEvent> eventBus) {
        this.view = view;
        this.installHelp();
        this.eventBus = eventBus;
        this.installListener();
    }

    protected void installHelp() {
        String helpId = this.getHelpID();
        if (helpId != null) {
            ((JSectionView)this.view).enableHelp(true);
            HelpAction helpAction = HelpAction.getInstance();
            helpAction.getHelpBroker().enableHelpOnButton((Component)((JSectionView)this.view).getHelpButton(), helpId, helpAction.getHelpSet());
        } else {
            ((JSectionView)this.view).enableHelp(false);
        }
    }

    protected void installListener() {
        this.listener = this.getSectionListener();
        ((JSectionView)this.view).setSectionListener(this.listener);
    }

    @Override
    public V getView() {
        return this.view;
    }

    @Override
    public void onHelp() {
    }

    @Override
    public void clear() {
    }

    protected abstract E getSectionListener();

    public void setHelpID(String helpID) {
        this.helpID = helpID;
        this.installHelp();
    }

    @Override
    public String getHelpID() {
        return this.helpID;
    }
}

