/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

public class CLIHelpId {
    public static final String DELIMITER = "#";
    private final String cmd;
    private final String arg;

    public CLIHelpId(String cmd, String arg) {
        this.cmd = cmd;
        this.arg = arg;
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getArg() {
        return this.arg;
    }

    public String idString() {
        return this.cmd + DELIMITER + this.arg;
    }

    public static CLIHelpId valueOf(String str) {
        String cmd = str;
        String arg = null;
        int pos = str.indexOf(DELIMITER);
        if (pos > 0) {
            cmd = str.substring(0, pos);
            arg = str.substring(pos);
        } else if (pos == 0) {
            throw new IllegalArgumentException("Command name start with illegal char");
        }
        return new CLIHelpId(cmd, arg);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arg == null ? 0 : this.arg.hashCode());
        result = 31 * result + (this.cmd == null ? 0 : this.cmd.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CLIHelpId other = (CLIHelpId)obj;
        if (this.arg == null ? other.arg != null : !this.arg.equals(other.arg)) {
            return false;
        }
        return !(this.cmd == null ? other.cmd != null : !this.cmd.equals(other.cmd));
    }

    public String toString() {
        return "CLIHelpId [cmd=" + this.cmd + ", arg=" + this.arg + "]";
    }
}

