/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.BaseCardController;
import com.intel.stl.ui.common.IPinDelegator;
import com.intel.stl.ui.common.PinArgument;
import com.intel.stl.ui.common.UndoableChartSelection;
import com.intel.stl.ui.common.UndoableJumpEvent;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.IChartsCardListener;
import com.intel.stl.ui.event.JumpDestination;
import com.intel.stl.ui.event.JumpToEvent;
import com.intel.stl.ui.event.PortsSelectedEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.model.DatasetDescription;
import com.intel.stl.ui.model.PortEntry;
import java.util.List;
import net.engio.mbassy.bus.MBassador;

public class ChartsCard
extends BaseCardController<IChartsCardListener, ChartsView>
implements IChartsCardListener {
    private IPinDelegator pinDelegator;
    private UndoHandler undoHandler;
    private JumpToEvent origin;
    private String currentChart;

    public ChartsCard(ChartsView view, MBassador<IAppEvent> eventBus, List<DatasetDescription> datasets) {
        super(view, eventBus);
        view.setDatasets(datasets);
        if (datasets != null && !datasets.isEmpty()) {
            this.currentChart = datasets.get(0).getName();
        }
        view.setChart(this.currentChart);
    }

    public void setUndoHandler(UndoHandler undoHandler, JumpToEvent source) {
        this.undoHandler = undoHandler;
        this.origin = source;
    }

    public void setOrigin(JumpToEvent origin) {
        this.origin = origin;
    }

    @Override
    public void onSelectChart(String name) {
        String oldChart = this.currentChart;
        this.currentChart = name;
        ((ChartsView)this.view).setChart(this.currentChart);
        if (this.undoHandler != null && !this.undoHandler.isInProgress()) {
            UndoableChartSelection undoSel = new UndoableChartSelection(this, oldChart, name);
            this.undoHandler.addUndoAction(undoSel);
        }
    }

    public void selectChart(String name) {
        ((ChartsView)this.view).selectChart(name);
    }

    public String getCurrentChart() {
        return this.currentChart;
    }

    @Override
    public IChartsCardListener getCardListener() {
        return this;
    }

    @Override
    public void jumpTo(Object content, JumpDestination destination) {
        if (content instanceof PortEntry) {
            PortEntry pe = (PortEntry)content;
            PortsSelectedEvent event = new PortsSelectedEvent(pe.getNodeLid(), pe.getPortNum(), this, destination.getName());
            this.eventBus.publish((Object)event);
            if (this.undoHandler != null && !this.undoHandler.isInProgress()) {
                UndoableJumpEvent undoSel = new UndoableJumpEvent((MBassador<IAppEvent>)this.eventBus, this.origin, event);
                this.undoHandler.addUndoAction(undoSel);
            }
        }
    }

    public void setPinDelegator(IPinDelegator pinDelegator) {
        this.pinDelegator = pinDelegator;
    }

    @Override
    public void onPin() {
        if (this.pinDelegator != null) {
            PinArgument arg = this.getChartProperties();
            this.pinDelegator.addPin(this.currentChart, arg);
        }
    }

    protected PinArgument getChartProperties() {
        PinArgument res = new PinArgument();
        res.put("Name", this.currentChart);
        return res;
    }
}

