/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.BaseSectionController;
import com.intel.stl.ui.common.ICardController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ObserverAdapter;
import com.intel.stl.ui.common.UndoableChartGroupSelection;
import com.intel.stl.ui.common.view.ChartsSectionView;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.event.JumpToEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.model.ChartGroup;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.IGroupController;
import com.intel.stl.ui.performance.provider.DataProviderName;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.engio.mbassy.bus.MBassador;

public abstract class ChartsSectionController
extends BaseSectionController<ISectionListener, ChartsSectionView>
implements ChangeListener {
    public static final String UTIL = "Util";
    public static final String ERR = "Error";
    protected int topN = 10;
    private final List<IGroupController<GroupSource>> groups = new ArrayList<IGroupController<GroupSource>>();
    private UndoHandler undoHandler;

    public ChartsSectionController(ChartsSectionView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        ChartGroup utilGroup = new ChartGroup(UTIL, null);
        IGroupController<GroupSource>[] tmp = this.getUtilGroups();
        for (int i = 0; i < tmp.length; ++i) {
            utilGroup.addMember(tmp[i].getGroup());
            this.groups.add(tmp[i]);
        }
        ChartGroup errGroup = new ChartGroup(ERR, null);
        tmp = this.getErrorGroups();
        for (int i = 0; i < tmp.length; ++i) {
            errGroup.addMember(tmp[i].getGroup());
            this.groups.add(tmp[i]);
        }
        view.setListener(this);
        view.setChartGroups(new ChartGroup[]{utilGroup, errGroup});
    }

    protected abstract IGroupController<GroupSource>[] getUtilGroups();

    protected abstract IGroupController<GroupSource>[] getErrorGroups();

    public int getTopN() {
        return this.topN;
    }

    public void setTopN(int topN) {
        this.topN = topN;
    }

    @Override
    public ICardController<?>[] getCards() {
        return null;
    }

    public void setContext(Context context, IProgressObserver observer) {
        if (context != null && context.getController() != null) {
            this.undoHandler = context.getController().getUndoHandler();
        }
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        IProgressObserver[] subObservers = observer.createSubObservers(this.groups.size());
        for (int i = 0; i < this.groups.size(); ++i) {
            this.groups.get(i).setContext(context, subObservers[i]);
            subObservers[i].onFinish();
        }
        observer.onFinish();
    }

    public void onRefresh(IProgressObserver observer) {
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        IProgressObserver[] subObservers = observer.createSubObservers(this.groups.size());
        for (int i = 0; i < this.groups.size() && !observer.isCancelled(); ++i) {
            this.groups.get(i).onRefresh(subObservers[i]);
            subObservers[i].onFinish();
        }
        observer.onFinish();
    }

    public void setSource(GroupSource name) {
        for (int i = 0; i < this.groups.size(); ++i) {
            this.groups.get(i).setDataSources(new GroupSource[]{name});
        }
    }

    public void setDataProvider(DataProviderName name) {
        for (int i = 0; i < this.groups.size(); ++i) {
            this.groups.get(i).setDataProvider(name);
        }
    }

    public void setDisabledDataTypes(DataType defaultType, DataType ... types) {
        for (int i = 0; i < this.groups.size(); ++i) {
            this.groups.get(i).setDisabledDataTypes(defaultType, types);
        }
    }

    public void setOrigin(JumpToEvent origin) {
        for (IGroupController<GroupSource> group : this.groups) {
            group.setOrigin(origin);
        }
    }

    @Override
    protected ISectionListener getSectionListener() {
        return this;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ChartsSectionView.TabbedPanel panel = (ChartsSectionView.TabbedPanel)e.getSource();
        String category = panel.getName();
        String selection = panel.getSelection();
        if (category == UTIL) {
            this.initGroup(selection, this.getUtilGroups());
        } else if (category == ERR) {
            this.initGroup(selection, this.getErrorGroups());
        }
        if (this.undoHandler != null && !this.undoHandler.isInProgress()) {
            UndoableChartGroupSelection undoSel = new UndoableChartGroupSelection(panel, panel.getPreviousSelection(), selection);
            this.undoHandler.addUndoAction(undoSel);
        }
    }

    protected void initGroup(String name, IGroupController<GroupSource>[] groups) {
        for (IGroupController<GroupSource> group : groups) {
            if (group.getGroup().getName().equals(name)) {
                group.setSleepMode(false);
                continue;
            }
            group.setSleepMode(true);
        }
    }
}

