/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.api.notice.IEventSource;
import com.intel.stl.ui.common.FVTableModel;
import com.intel.stl.ui.common.STLConstants;

public class EventTableModel
extends FVTableModel<EventDescription> {
    private static final long serialVersionUID = -5075022331424320175L;
    public static final int TIME_IDX = 0;
    public static final int SEVERITY_IDX = 1;
    public static final int SOURCE_IDX = 2;
    public static final int DESCRIPTION_IDX = 3;

    public EventTableModel() {
        String[] columnNames = new String[]{STLConstants.K0401_TIME.getValue(), STLConstants.K0402_SEVERITY.getValue(), STLConstants.K0403_SOURCE.getValue(), STLConstants.K0405_DESCRIPTION.getValue()};
        this.setColumnNames(columnNames);
    }

    @Override
    public String getColumnName(int column) {
        return this.mColumnNames[column];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int pRow, int pCol) {
        Object value = null;
        EventDescription eventMsg = null;
        Object object = this.critical;
        synchronized (object) {
            eventMsg = (EventDescription)this.mEntryList.get(pRow);
        }
        if (eventMsg == null) {
            return null;
        }
        switch (pCol) {
            case 0: {
                value = eventMsg.getDate();
                break;
            }
            case 1: {
                value = eventMsg.getSeverity();
                break;
            }
            case 2: {
                IEventSource source = eventMsg.getSource();
                value = source == null ? STLConstants.K0383_NA.getValue() : source.getDescription();
                break;
            }
            case 3: {
                value = eventMsg.getType();
                break;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.critical;
        synchronized (object) {
            this.mEntryList.clear();
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

