/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.CLIHelpId;
import com.intel.stl.ui.common.IHelp;
import com.intel.stl.ui.common.view.HelpView;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelpContentViewer;
import javax.help.Map;

public class HelpController
implements IHelp {
    public static final String TOC = "toc";
    private final HelpView helpView;
    private final HelpSet helpSet;
    private final List<String> topicIdList = new ArrayList<String>();

    public HelpController(String title, String helpSetFilename) {
        this.helpSet = this.initHelpSet(helpSetFilename);
        if (this.helpSet == null) {
            throw new IllegalArgumentException("Connot load help set '" + helpSetFilename);
        }
        Enumeration ids = this.helpSet.getCombinedMap().getAllIDs();
        HashSet<String> cmds = new HashSet<String>();
        while (ids.hasMoreElements()) {
            String id = ((Map.ID)ids.nextElement()).id;
            CLIHelpId cliId = CLIHelpId.valueOf(id);
            cmds.add(cliId.getCmd());
        }
        this.topicIdList.addAll(cmds);
        Collections.sort(this.topicIdList);
        JHelpContentViewer viewer = new JHelpContentViewer(this.helpSet);
        this.helpView = new HelpView(title, this.topicIdList, viewer, this);
        this.helpView.selectTopic(TOC);
    }

    protected HelpSet initHelpSet(String fileName) {
        URL hsURL = HelpSet.findHelpSet(null, (String)fileName);
        HelpSet helpSet = null;
        try {
            helpSet = new HelpSet(null, hsURL);
        }
        catch (HelpSetException e) {
            e.printStackTrace();
        }
        return helpSet;
    }

    @Override
    public void showTopic(String topicId) {
        if (this.helpView != null) {
            this.helpView.displayTopic(topicId);
        }
    }

    @Override
    public HelpView getView() {
        return this.helpView;
    }

    @Override
    public void updateSelection(String value) {
        this.helpView.updateSelection(value);
    }

    @Override
    public List<String> getTopicIdList() {
        return this.topicIdList;
    }

    @Override
    public void resetView() {
        this.helpView.resetView();
    }

    @Override
    public void parseCommand(String command) {
        if (command != null) {
            if (!command.contains("-") && !this.topicIdList.contains(command)) {
                return;
            }
            int sectionIndex = 0;
            String[] options = command.split(" ");
            String topic = options[0];
            for (String option : options) {
                boolean isShortOptionLength;
                boolean hasLongOption = option.contains("--");
                boolean isLongOptionLength = option.length() == 2;
                boolean hasShortOption = option.contains("-");
                boolean bl = isShortOptionLength = option.length() == 1;
                if (hasLongOption && !isLongOptionLength || hasShortOption && !isShortOptionLength) {
                    sectionIndex = hasLongOption ? option.indexOf("--") + 2 : (hasShortOption ? option.indexOf("-") + 1 : 0);
                    topic = options[0] + "#" + option.substring(sectionIndex);
                }
                this.showTopic(topic);
            }
        }
    }
}

