/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.SwingUtilities;

public abstract class ButtonPopup
extends Popup
implements WindowFocusListener,
MouseListener {
    private static final String RESET_ACTION = "resetPopup";
    public static final short BUTTON_PRESSED = 0;
    public static final short FOCUS_LOST = 1;
    public static final short ESC_PRESSED = 2;
    private JWindow popup = null;
    private short hideReason = 0;
    private boolean hideReasonNotSet = true;
    private final AbstractButton button;
    private final JComponent component;
    private boolean isFrame = true;
    private ComponentListener parentComponentListener;

    public ButtonPopup(AbstractButton button, JComponent component) {
        this.component = component;
        this.button = button;
        this.button.addMouseListener(this);
    }

    public ButtonPopup(AbstractButton button, JComponent component, boolean isFrame) {
        this.component = component;
        this.button = button;
        this.button.addMouseListener(this);
        this.isFrame = isFrame;
    }

    protected ComponentListener getParentComponentListener() {
        if (this.parentComponentListener == null) {
            this.parentComponentListener = new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ButtonPopup.this.hidePopup();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    ButtonPopup.this.hidePopup();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    ButtonPopup.this.hidePopup();
                }
            };
        }
        return this.parentComponentListener;
    }

    @Override
    public void show() {
        this.onShow();
        if (this.popup == null) {
            this.createPopup();
        }
        this.popup.getParent().addComponentListener(this.getParentComponentListener());
        Point location = this.button.getLocation();
        SwingUtilities.convertPointToScreen(location, this.button.getParent());
        int dy = this.button.getHeight() + (this.button.getBorder() == null ? 0 : this.button.getBorder().getBorderInsets((Component)this.button).bottom);
        location.translate(0, dy);
        Dimension dim = this.component.getPreferredSize();
        location = Util.adjustPoint(new Rectangle(location.x, location.y, dim.width, dim.height), SwingUtilities.getWindowAncestor(this.button));
        this.popup.setLocation(location);
        this.popup.addWindowFocusListener(this);
        this.popup.setSize(dim);
        this.popup.validate();
        this.popup.setVisible(true);
        this.popup.requestFocus();
        this.hideReasonNotSet = true;
    }

    @Override
    public void hide() {
        this.popup.getParent().removeComponentListener(this.getParentComponentListener());
        this.popup.setVisible(false);
        this.popup.removeWindowFocusListener(this);
        this.onHide();
        this.hideReasonNotSet = true;
    }

    protected void hidePopup() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ButtonPopup.this.popup.isVisible()) {
                    if (ButtonPopup.this.hideReasonNotSet) {
                        ButtonPopup.this.hideReason = (short)1;
                    }
                    ButtonPopup.this.button.doClick();
                }
            }
        });
    }

    public boolean isVisible() {
        return this.popup != null && this.popup.isVisible();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.hidePopup();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.hideReason = 0;
        this.hideReasonNotSet = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public JComponent getContentPane() {
        return this.component;
    }

    public short getHideReason() {
        return this.hideReason;
    }

    protected void reset() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ButtonPopup.this.popup.isVisible()) {
                    ButtonPopup.this.hideReason = (short)2;
                    ButtonPopup.this.button.doClick();
                }
            }
        });
    }

    public abstract void onShow();

    public abstract void onHide();

    private void createPopup() {
        if (this.isFrame) {
            JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this.button);
            this.popup = new JWindow(frame);
        } else {
            JDialog dialog = (JDialog)SwingUtilities.getWindowAncestor(this.button);
            this.popup = new JWindow(dialog);
        }
        this.popup.setFocusable(true);
        this.popup.setContentPane(this.component);
        this.component.setBorder(new JPopupMenu().getBorder());
        this.component.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), RESET_ACTION);
        AbstractAction resetAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPopup.this.reset();
            }
        };
        this.component.getActionMap().put(RESET_ACTION, resetAction);
        this.popup.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ButtonPopup.this.reset();
                }
            }
        });
    }
}

