/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class DistributionPiePanel
extends JPanel {
    private static final long serialVersionUID = -8922967649586607241L;
    private ChartPanel chartPanel = new ChartPanel(null);
    private JPanel labelPanel;
    private JLabel[] labels;

    public DistributionPiePanel() {
        super(new BorderLayout(0, 0));
        this.add((Component)this.chartPanel, "Center");
        this.labelPanel = new JPanel();
        this.labelPanel.setOpaque(false);
        this.add((Component)this.labelPanel, "South");
    }

    public void setDataset(DefaultPieDataset dataset, Color[] colors) {
        JFreeChart chart = ComponentFactory.createPlainPieChart((PieDataset)dataset, colors);
        this.chartPanel.setChart(chart);
    }

    public void setLabels(String[] itemNames, ImageIcon[] icons, int labelColumns) {
        if (icons.length != itemNames.length) {
            throw new IllegalArgumentException("Inconsistent number of items.  itemNames=" + itemNames.length + " icons=" + icons.length);
        }
        this.labels = new JLabel[icons.length];
        for (int i = 0; i < icons.length; ++i) {
            this.labels[i] = new JLabel(itemNames[i], icons[i], 2);
        }
        int rows = 1;
        if (labelColumns <= 0) {
            this.labelPanel.setLayout(new FlowLayout());
            for (JLabel label : this.labels) {
                this.labelPanel.add(label);
            }
        } else {
            BoxLayout layout = new BoxLayout(this.labelPanel, 0);
            this.labelPanel.setLayout(layout);
            JPanel[] columns = new JPanel[labelColumns];
            for (int i = 0; i < columns.length; ++i) {
                this.labelPanel.add(Box.createHorizontalGlue());
                columns[i] = new JPanel();
                columns[i].setOpaque(false);
                columns[i].setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
                BoxLayout cLayout = new BoxLayout(columns[i], 1);
                columns[i].setLayout(cLayout);
                this.labelPanel.add(columns[i]);
            }
            this.labelPanel.add(Box.createHorizontalGlue());
            rows = (int)Math.ceil((double)this.labels.length / (double)labelColumns);
            int index = 0;
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < labelColumns; ++j) {
                    columns[i].add(index < this.labels.length ? this.labels[index] : Box.createGlue());
                    ++index;
                }
            }
        }
    }

    public void update(String[] itemLabels) {
        if (itemLabels.length != this.labels.length) {
            throw new IllegalArgumentException("Incorrect array size. Expected " + this.labels.length + " items, got " + itemLabels.length + " items.");
        }
        this.chartPanel.getChart().fireChartChanged();
        for (int i = 0; i < itemLabels.length; ++i) {
            this.labels[i].setText(itemLabels[i]);
        }
        this.validate();
    }
}

