/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.main.view.IProgressListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class ProgressPanel
extends JPanel {
    private static final long serialVersionUID = 1912574664805410774L;
    private JLabel label;
    private JLabel running;
    private JProgressBar progressBar;
    private JButton btnCancel;
    private final int margin = 20;
    private final IProgressListener progressListener;

    public ProgressPanel(boolean isIndeterminate, IProgressListener progressListener) {
        this.progressListener = progressListener;
        this.initComponent(isIndeterminate);
    }

    protected void initComponent(boolean isIndeterminate) {
        this.setOpaque(true);
        this.setBackground(new Color(255, 255, 255, 230));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BLUE, 2), BorderFactory.createEmptyBorder(20, 20, 20, 20)));
        this.setLayout(new BorderLayout(5, 5));
        this.label = ComponentFactory.getH2Label("", 0);
        this.add((Component)this.label, "North");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(true);
        panel.setBackground(UIConstants.INTEL_WHITE);
        panel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.running = new JLabel();
        this.running.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        panel.add((Component)this.running, "West");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setUI(new BasicProgressBarUI());
        this.progressBar.setBorderPainted(false);
        if (isIndeterminate) {
            this.progressBar.setIndeterminate(true);
        }
        panel.add((Component)this.progressBar, "Center");
        this.add((Component)panel, "Center");
        this.btnCancel = ComponentFactory.getIntelActionButton(STLConstants.K0621_CANCEL.getValue());
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProgressPanel.this.progressListener != null) {
                    ProgressPanel.this.progressListener.onCancel();
                }
            }
        });
        this.add((Component)this.btnCancel, "East");
        this.btnCancel.setVisible(false);
    }

    public void setProgress(int value) {
        if (value > 0 && this.progressBar.isIndeterminate()) {
            this.progressBar.setIndeterminate(false);
        }
        this.progressBar.setValue(value);
    }

    public double getPercentComplete() {
        return this.progressBar.getPercentComplete();
    }

    public void setProgressNote(String text) {
        if (text != null) {
            if (!this.progressBar.isStringPainted()) {
                this.progressBar.setStringPainted(true);
            }
            this.progressBar.setString(text);
        } else if (text == null && this.progressBar.isStringPainted()) {
            this.progressBar.setStringPainted(false);
        }
    }

    public void setLabel(String text) {
        this.label.setText(text);
        this.running.setIcon(text == null ? null : UIImages.RUNNING.getImageIcon());
    }

    public void setCancellable(boolean cancellable) {
        this.btnCancel.setVisible(cancellable);
    }
}

