/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.configuration.PropertyGroup;
import com.intel.stl.api.configuration.ResourceType;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.ui.common.FinishObserver;
import com.intel.stl.ui.common.IPerfSubpageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ObserverAdapter;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.GetDevicePropertiesTask;
import com.intel.stl.ui.configuration.PropertyGroupController;
import com.intel.stl.ui.configuration.view.DevicePropertiesPanel;
import com.intel.stl.ui.configuration.view.DevicePropertyGroupPanel;
import com.intel.stl.ui.configuration.view.IPropertyListener;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.framework.AbstractController;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.model.DeviceProperties;
import com.intel.stl.ui.model.DevicePropertyGroup;
import com.intel.stl.ui.model.PropertyGroupViz;
import com.intel.stl.ui.monitor.PerformanceTreeController;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import net.engio.mbassy.bus.MBassador;

public class DevicePropertiesController
extends AbstractController<DeviceProperties, DevicePropertiesPanel, DevicePropertiesController>
implements IPerfSubpageController,
IPropertyListener {
    private GetDevicePropertiesTask propertiesTask;
    private Timer viewClearTimer;
    private UserSettings userSettings;
    private FVResourceNode currentNode;
    private PerformanceTreeController parentController;
    private final PropertyVizStyle style = new PropertyVizStyle();

    public DevicePropertiesController(DeviceProperties model, DevicePropertiesPanel view, MBassador<IAppEvent> eventBus) {
        super(model, view, eventBus);
    }

    @Override
    public void initModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContext(Context context, IProgressObserver observer) {
        try {
            super.setContext(context);
            this.userSettings = context.getUserSettings();
        }
        finally {
            observer.onFinish();
        }
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        if (this.currentNode != null) {
            this.showNode(this.currentNode, observer);
        }
        observer.onFinish();
    }

    @Override
    public void onTaskSuccess() {
        this.clearTimer();
        ((DevicePropertiesPanel)this.view).clearPanel();
        for (DevicePropertyGroup group : ((DeviceProperties)this.model).getGroups()) {
            try {
                DevicePropertyGroupPanel groupPanel = new DevicePropertyGroupPanel(this.style);
                String helpID = this.getHelpID(((DeviceProperties)this.model).getResourceType(), group);
                new PropertyGroupController(group, groupPanel, (MBassador<IAppEvent>)this.eventBus, helpID);
                ((DevicePropertiesPanel)this.view).addPropertyGroupPanel(groupPanel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<PropertyGroup> groups = this.userSettings.getPropertiesDisplayOptions().get((Object)((DeviceProperties)this.model).getResourceType());
        if (groups != null) {
            ((DevicePropertiesPanel)this.view).initUserSettings(groups);
        }
        this.notifyModelChanged();
    }

    protected String getHelpID(ResourceType type, DevicePropertyGroup group) {
        String title = group.getGroupName();
        PropertyGroupViz pgViz = PropertyGroupViz.getPropertyGroupVizByTitle(title);
        HelpAction helpAction = HelpAction.getInstance();
        switch (pgViz) {
            case GENERAL: {
                return helpAction.getNodeGeneral();
            }
            case SWITCH_INFO: {
                return helpAction.getSwitchInformation();
            }
            case ROUTING_INFO: {
                return helpAction.getRoutingInformation();
            }
            case DEVICE_GROUP: {
                return helpAction.getDeviceGroup();
            }
            case MFT: {
                return helpAction.getMft();
            }
            case LFT: {
                return helpAction.getLft();
            }
            case DEVICE_INFO: {
                return helpAction.getPortDevInfo();
            }
            case PORT_LINK: {
                return helpAction.getPortLink();
            }
            case LINK_CONNECTION: {
                return helpAction.getPortLinkConn();
            }
            case PORT_CAPABILITY: {
                return helpAction.getPortCap();
            }
            case VIRTUAL_LANE: {
                return helpAction.getVL();
            }
            case PORT_DIAGNOSTICS: {
                return helpAction.getDiagnostics();
            }
            case PORT_PARTITION_ENFORCEMENT: {
                return helpAction.getPartition();
            }
            case PORT_MANAGEMENT: {
                return helpAction.getManagement();
            }
            case FLIT_CONTROL: {
                return helpAction.getFlitControl();
            }
            case PORT_ERROR_ACTIONS: {
                return helpAction.getPortErrorActions();
            }
            case MISCELLANEOUS: {
                return helpAction.getMisc();
            }
            case MTU: {
                return helpAction.getMTUByVL();
            }
            case HOQLIFE: {
                return helpAction.getHoQLifeByVL();
            }
            case VL_STALL_COUNT: {
                return helpAction.getStallCountByVL();
            }
            case CABLE_INFO: {
                return helpAction.getQSFP();
            }
            case SC2SLMT: {
                return helpAction.getSC2SL();
            }
            case SC2VLTMT: {
                return helpAction.getSC2VLT();
            }
            case SC2VLNTMT: {
                return helpAction.getSC2VLNT();
            }
            case LINK_DOWN_ERROR_REASON: {
                return helpAction.getLinkDownError();
            }
        }
        return null;
    }

    @Override
    public void onTaskFailure(Throwable caught) {
        this.clearTimer();
        this.notifyModelUpdateFailed(caught);
    }

    @Override
    public String getName() {
        return STLConstants.K0300_PROPERTIES.getValue();
    }

    @Override
    public String getDescription() {
        return STLConstants.K0301_PROPERTIES_DESCRIPTION.getValue();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void clear() {
        if (this.viewClearTimer == null) {
            this.viewClearTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DevicePropertiesController.this.viewClearTimer != null) {
                        ((DevicePropertiesPanel)DevicePropertiesController.this.view).clear();
                    }
                }
            });
            this.viewClearTimer.setRepeats(false);
        }
        this.viewClearTimer.restart();
    }

    @Override
    public void showNode(FVResourceNode node, IProgressObserver observer) {
        ResourceType resourceType;
        if (this.propertiesTask != null && this.propertiesTask.isSubmitted() && !this.propertiesTask.isDone()) {
            try {
                this.propertiesTask.cancel(true);
            }
            catch (CancellationException e) {
                // empty catch block
            }
        }
        if ((resourceType = TreeNodeType.getResourceTypeFor(node.getType())) == null) {
            this.currentNode = node;
            return;
        }
        ((DeviceProperties)this.model).setResourceType(resourceType);
        this.propertiesTask = new GetDevicePropertiesTask((DeviceProperties)this.model, node, observer);
        this.submitTask(this.propertiesTask);
        this.currentNode = node;
    }

    @Override
    public void setParentController(PerformanceTreeController parentController) {
        this.parentController = parentController;
    }

    protected void clearTimer() {
        if (this.viewClearTimer != null) {
            if (this.viewClearTimer.isRunning()) {
                this.viewClearTimer.stop();
            }
            this.viewClearTimer = null;
        }
    }

    public UserSettings getUserSettings() {
        return this.userSettings;
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }

    protected GetDevicePropertiesTask getTask() {
        return this.propertiesTask;
    }

    @Override
    public void onShowBorder(boolean isSelected) {
        this.style.setShowBorder(isSelected);
        this.onTaskSuccess();
    }

    @Override
    public void onShowAlternation(boolean isSelected) {
        this.style.setAlternateRows(isSelected);
        this.onTaskSuccess();
    }

    @Override
    public void onDisplayChanged(Map<String, Boolean> newSelections) {
        if (this.applyChange(newSelections)) {
            if (this.parentController != null) {
                this.parentController.setRunning(true);
                this.showNode(this.currentNode, new FinishObserver(){

                    @Override
                    public void onFinish() {
                        DevicePropertiesController.this.parentController.setRunning(false);
                    }
                });
            } else {
                this.showNode(this.currentNode, null);
            }
        }
    }

    protected boolean applyChange(Map<String, Boolean> newSelections) {
        boolean changed = false;
        List<PropertyGroup> groups = this.userSettings.getPropertiesDisplayOptions().get((Object)((DeviceProperties)this.model).getResourceType());
        if (groups != null) {
            for (PropertyGroup group : groups) {
                Boolean newSelection = newSelections.get(group.getName());
                if (newSelection == null || newSelection.equals(group.isDisplayed())) continue;
                changed = true;
                group.setDisplayed(newSelection);
            }
        }
        return changed;
    }
}

