/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class DiagnosticsProcessor
extends BaseCategoryProcessor {
    private static final int FORMAT_MULT_THRESHOLD_FRACTION = 1000;

    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        boolean isEndPort = context.isEndPort();
        boolean isHFI = context.isHFI();
        boolean isExternalSWPort = context.isExternalSWPort();
        if (portInfo != null) {
            String na;
            DiagnosticsProcessor.addProperty(category, DeviceProperty.PORT_OVERALL_BUFF_SPACE, DiagnosticsProcessor.hex(portInfo.getOverallBufferSpace()));
            if (isExternalSWPort || isHFI) {
                DiagnosticsProcessor.addProperty(category, DeviceProperty.REPLAY_DEPTH_BUFFER, DiagnosticsProcessor.hex(portInfo.getBufferDepth()));
                DiagnosticsProcessor.addProperty(category, DeviceProperty.REPLAY_DEPTH_WIRE, DiagnosticsProcessor.hex(portInfo.getWireDepth()));
            } else {
                DiagnosticsProcessor.addProperty(category, DeviceProperty.REPLAY_DEPTH_BUFFER, STLConstants.K0383_NA.getValue());
                DiagnosticsProcessor.addProperty(category, DeviceProperty.REPLAY_DEPTH_WIRE, STLConstants.K0383_NA.getValue());
            }
            String value = na = STLConstants.K0383_NA.getValue();
            if (isEndPort) {
                value = Byte.toString(portInfo.getMasterSMSL());
            }
            DiagnosticsProcessor.addProperty(category, DeviceProperty.MASTER_SMSL, value);
            value = Byte.toString(portInfo.getMasterSMSL());
            if (isExternalSWPort) {
                DiagnosticsProcessor.addProperty(category, DeviceProperty.M_KEY_VIOLATIONS, na);
                DiagnosticsProcessor.addProperty(category, DeviceProperty.P_KEY_VIOLATIONS, na);
                DiagnosticsProcessor.addProperty(category, DeviceProperty.Q_KEY_VIOLATIONS, na);
            } else {
                DiagnosticsProcessor.addProperty(category, DeviceProperty.M_KEY_VIOLATIONS, value);
                value = Short.toString(portInfo.getPKeyViolation());
                DiagnosticsProcessor.addProperty(category, DeviceProperty.P_KEY_VIOLATIONS, value);
                value = Short.toString(portInfo.getQKeyViolation());
                DiagnosticsProcessor.addProperty(category, DeviceProperty.Q_KEY_VIOLATIONS, value);
            }
            value = this.formatTimeout(portInfo.getRespTimeValue());
            DiagnosticsProcessor.addProperty(category, DeviceProperty.RESPONSE_TIME, value);
            if (isExternalSWPort) {
                DiagnosticsProcessor.addProperty(category, DeviceProperty.SUBNET_TIMEOUT, na);
            } else {
                value = this.formatTimeout(portInfo.getSubnetTimeout());
                DiagnosticsProcessor.addProperty(category, DeviceProperty.SUBNET_TIMEOUT, value);
            }
        } else {
            DiagnosticsProcessor.addProperty(category, DeviceProperty.PORT_GANGED_DETAILS, "");
            DiagnosticsProcessor.addProperty(category, DeviceProperty.PORT_OVERALL_BUFF_SPACE, "");
            DiagnosticsProcessor.addProperty(category, DeviceProperty.REPLAY_DEPTH_BUFFER, "");
            DiagnosticsProcessor.addProperty(category, DeviceProperty.REPLAY_DEPTH_WIRE, "");
            DiagnosticsProcessor.addProperty(category, DeviceProperty.MASTER_SMSL, "");
            DiagnosticsProcessor.addProperty(category, DeviceProperty.M_KEY_VIOLATIONS, "");
            DiagnosticsProcessor.addProperty(category, DeviceProperty.P_KEY_VIOLATIONS, "");
            DiagnosticsProcessor.addProperty(category, DeviceProperty.Q_KEY_VIOLATIONS, "");
            DiagnosticsProcessor.addProperty(category, DeviceProperty.RESPONSE_TIME, "");
            DiagnosticsProcessor.addProperty(category, DeviceProperty.SUBNET_TIMEOUT, "");
        }
    }

    private String formatTimeout(byte timeout) {
        double exp = Math.pow(2.0, timeout);
        long val = 4096L * (long)exp;
        if (val < 1000L) {
            return String.format("%d ns", val);
        }
        if ((val /= 1000L) < 1000L) {
            return String.format("%d \u00b5s", val);
        }
        if ((val /= 1000L) < 1000L) {
            return String.format("%d ms", val);
        }
        return String.format("%d sec", val /= 1000L);
    }
}

