/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.configuration.MTUSize;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import java.util.ArrayList;

public class MTUByVLProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        if (portInfo != null) {
            this.getNeighborMTUByVL(category, portInfo.getNeighborVL0MTU(), portInfo.getNeighborVL1MTU());
        }
    }

    private void getNeighborMTUByVL(DevicePropertyCategory category, byte[] vl0mtu, byte[] vl1mtu) {
        ArrayList<MTUSize> mtuSeries = new ArrayList<MTUSize>();
        for (int i = 0; i < vl0mtu.length; ++i) {
            mtuSeries.add(MTUSize.getMTUSize(vl0mtu[i]));
            mtuSeries.add(MTUSize.getMTUSize(vl1mtu[i]));
        }
        MTUSize[] series = new MTUSize[mtuSeries.size()];
        for (int i = 0; i < mtuSeries.size(); ++i) {
            series[i] = (MTUSize)((Object)mtuSeries.get(i));
        }
        DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.MTU_SERIES, (Object)series);
        category.addPropertyItem(property);
        DevicePropertyItem numVLs = new DevicePropertyItem(DeviceProperty.NUM_VL, (Object)new Integer(32));
        category.addPropertyItem(numVLs);
    }
}

