/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class NeighborModeProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        boolean isHFI = context.isHFI();
        boolean isExternalSWPort = context.isExternalSWPort();
        if (portInfo == null) {
            this.getEmptyPortNeighborMode(category);
            return;
        }
        String value = STLConstants.K0082_NO.getValue();
        if (portInfo.isMgmtAllowed()) {
            value = STLConstants.K0081_YES.getValue();
        }
        NeighborModeProcessor.addProperty(category, DeviceProperty.NEIGHBOR_MGMT_ALLOWED, value);
        if (isExternalSWPort || isHFI) {
            value = STLConstants.K0699_OFF.getValue();
            if (portInfo.isNeighborFWAuthenBypass()) {
                value = STLConstants.K0080_ON.getValue();
            }
            NeighborModeProcessor.addProperty(category, DeviceProperty.NEIGHBOR_FW_AUTH_BYPASS, value);
            value = portInfo.getNeighborNodeType() != 0 ? STLConstants.K0004_SWITCH.getValue() : STLConstants.K0018_HFI.getValue();
            NeighborModeProcessor.addProperty(category, DeviceProperty.NEIGHBOR_NODE_TYPE, value);
        } else {
            NeighborModeProcessor.addProperty(category, DeviceProperty.NEIGHBOR_FW_AUTH_BYPASS, STLConstants.K0383_NA.getValue());
            NeighborModeProcessor.addProperty(category, DeviceProperty.NEIGHBOR_NODE_TYPE, STLConstants.K0383_NA.getValue());
        }
    }

    private void getEmptyPortNeighborMode(DevicePropertyCategory category) {
        NeighborModeProcessor.addProperty(category, DeviceProperty.NEIGHBOR_MGMT_ALLOWED, "");
        NeighborModeProcessor.addProperty(category, DeviceProperty.NEIGHBOR_FW_AUTH_BYPASS, "");
        NeighborModeProcessor.addProperty(category, DeviceProperty.NEIGHBOR_NODE_TYPE, "");
    }
}

