/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class PortModeProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        String falseStr;
        PortInfoBean portInfo = context.getPortInfo();
        if (portInfo == null) {
            this.getEmptyPortMode(category);
            return;
        }
        String trueStr = STLConstants.K0385_TRUE.getValue();
        String value = falseStr = STLConstants.K0386_FALSE.getValue();
        if (portInfo.isActiveOptimizeEnabled()) {
            value = trueStr;
        }
        PortModeProcessor.addProperty(category, DeviceProperty.ACTIVE_OPTIMIZE, value);
        value = falseStr;
        if (portInfo.isPassThroughEnabled()) {
            value = trueStr;
        }
        PortModeProcessor.addProperty(category, DeviceProperty.PASSTHRU, value);
        value = falseStr;
        if (portInfo.isVLMarkerEnabled()) {
            value = trueStr;
        }
        PortModeProcessor.addProperty(category, DeviceProperty.VL_MARKER, value);
        value = falseStr;
        if (portInfo.is16BTrapQueryEnabled()) {
            value = trueStr;
        }
        PortModeProcessor.addProperty(category, DeviceProperty.TRAP_QUERY_16B, value);
    }

    private void getEmptyPortMode(DevicePropertyCategory category) {
        PortModeProcessor.addProperty(category, DeviceProperty.ACTIVE_OPTIMIZE, "");
        PortModeProcessor.addProperty(category, DeviceProperty.PASSTHRU, "");
        PortModeProcessor.addProperty(category, DeviceProperty.VL_MARKER, "");
        PortModeProcessor.addProperty(category, DeviceProperty.TRAP_QUERY_16B, "");
    }
}

