/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.configuration.ResourceCategory;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.AdaptiveRoutingProcessor;
import com.intel.stl.ui.configuration.BufferUnitsProcessor;
import com.intel.stl.ui.configuration.CableInfoProcessor;
import com.intel.stl.ui.configuration.DeviceGroupsProcessor;
import com.intel.stl.ui.configuration.DiagnosticsProcessor;
import com.intel.stl.ui.configuration.FlitControlInterleaveProcessor;
import com.intel.stl.ui.configuration.FlitControlPreemptionProcessor;
import com.intel.stl.ui.configuration.ForwardingInfoProcessor;
import com.intel.stl.ui.configuration.HoQLifeProcessor;
import com.intel.stl.ui.configuration.LFTSeriesProcessor;
import com.intel.stl.ui.configuration.LFTTableProcessor;
import com.intel.stl.ui.configuration.LinkConnectedToProcessor;
import com.intel.stl.ui.configuration.LinkDownErrorLogProcessor;
import com.intel.stl.ui.configuration.LinkModeProcessor;
import com.intel.stl.ui.configuration.LinkSpeedProcessor;
import com.intel.stl.ui.configuration.LinkWidthDowngradeProcessor;
import com.intel.stl.ui.configuration.LinkWidthProcessor;
import com.intel.stl.ui.configuration.LtpCrcModeProcessor;
import com.intel.stl.ui.configuration.MFTTableProcessor;
import com.intel.stl.ui.configuration.MTUByVLProcessor;
import com.intel.stl.ui.configuration.NeighborLinkDownErrorLogProcessor;
import com.intel.stl.ui.configuration.NeighborModeProcessor;
import com.intel.stl.ui.configuration.NodeInfoProcessor;
import com.intel.stl.ui.configuration.NodePortInfoProcessor;
import com.intel.stl.ui.configuration.PacketFormatProcessor;
import com.intel.stl.ui.configuration.PortCapabilitiesProcessor;
import com.intel.stl.ui.configuration.PortErrorActionsProcessor;
import com.intel.stl.ui.configuration.PortIPAddressProcessor;
import com.intel.stl.ui.configuration.PortInfoProcessor;
import com.intel.stl.ui.configuration.PortManagementProcessor;
import com.intel.stl.ui.configuration.PortModeProcessor;
import com.intel.stl.ui.configuration.PortPartitionEnforcementProcessor;
import com.intel.stl.ui.configuration.PortSubnetProcessor;
import com.intel.stl.ui.configuration.ResourceCategoryProcessor;
import com.intel.stl.ui.configuration.SC2SLMTProcessor;
import com.intel.stl.ui.configuration.SC2VLNTMTProcessor;
import com.intel.stl.ui.configuration.SC2VLTMTProcessor;
import com.intel.stl.ui.configuration.SwitchIPAddressProcessor;
import com.intel.stl.ui.configuration.SwitchInfoProcessor;
import com.intel.stl.ui.configuration.SwitchPartitionEnforcementProcessor;
import com.intel.stl.ui.configuration.SwitchRoutingProcessor;
import com.intel.stl.ui.configuration.VLStallCountByVLProcessor;
import com.intel.stl.ui.configuration.VirtualLaneProcessor;
import java.util.EnumMap;

public enum ResourceCategoryMap {
    NODE_INFO(ResourceCategory.NODE_INFO, STLConstants.K0307_DEV_INFO_TITLE.getValue(), null, NodeInfoProcessor.class),
    DEVICE_GROUPS(ResourceCategory.DEVICE_GROUPS, null, null, DeviceGroupsProcessor.class),
    LINK_WIDTH(ResourceCategory.LINK_WIDTH, STLConstants.K0319_PORT_LINK_WIDTH.getValue(), null, LinkWidthProcessor.class),
    LINK_WIDTH_DOWNGRADE(ResourceCategory.LINK_WIDTH_DOWNGRADE, STLConstants.K0084_LINK_WIDTH_DOWNGRADE.getValue(), null, LinkWidthDowngradeProcessor.class),
    LINK_SPEED(ResourceCategory.LINK_SPEED, STLConstants.K0323_PORT_LINK_SPEED.getValue(), null, LinkSpeedProcessor.class),
    LINK_CONNECTED_TO(ResourceCategory.LINK_CONNECTED_TO, STLConstants.K0324_PORT_LINK_CONN_TO.getValue(), null, LinkConnectedToProcessor.class),
    NEIGHBOR_MODE(ResourceCategory.NEIGHBOR_MODE, STLConstants.K0497_NEIGHBOR_MODE.getValue(), null, NeighborModeProcessor.class),
    NODE_PORT_INFO(ResourceCategory.NODE_PORT_INFO, STLConstants.K0392_PORT_PROPERTIES.getValue(), null, NodePortInfoProcessor.class),
    PORT_INFO(ResourceCategory.PORT_INFO, null, null, PortInfoProcessor.class),
    PORT_LINK_MODE(ResourceCategory.PORT_LINK_MODE, STLConstants.K0455_PORT_LINK_MODE.getValue(), null, LinkModeProcessor.class),
    PORT_LTP_CRC_MODE(ResourceCategory.PORT_LTP_CRC_MODE, STLConstants.K0456_PORT_LTP_CRC_MODE.getValue(), null, LtpCrcModeProcessor.class),
    PORT_MODE(ResourceCategory.PORT_MODE, STLConstants.K0815_PORT_MODE.getValue(), null, PortModeProcessor.class),
    PORT_PACKET_FORMAT(ResourceCategory.PORT_PACKET_FORMAT, STLConstants.K0827_PACKET_FORMAT.getValue(), null, PacketFormatProcessor.class),
    PORT_ERROR_ACTIONS(ResourceCategory.PORT_ERROR_ACTIONS, null, null, PortErrorActionsProcessor.class),
    PORT_BUFFER_UNITS(ResourceCategory.PORT_BUFFER_UNITS, STLConstants.K0817_BUFFER_UNITS.getValue(), null, BufferUnitsProcessor.class),
    PORT_IPADDR(ResourceCategory.PORT_IPADDR, STLConstants.K0440_IP_ADDR.getValue(), null, PortIPAddressProcessor.class),
    PORT_SUBNET(ResourceCategory.PORT_SUBNET, STLConstants.K0007_SUBNET.getValue(), null, PortSubnetProcessor.class),
    PORT_CAPABILITIES(ResourceCategory.PORT_CAPABILITIES, null, null, PortCapabilitiesProcessor.class),
    PORT_DIAGNOSTICS(ResourceCategory.PORT_DIAGNOSTICS, null, null, DiagnosticsProcessor.class),
    PORT_MANAGEMENT(ResourceCategory.PORT_MANAGEMENT, null, null, PortManagementProcessor.class),
    PORT_PARTITION_ENFORCEMENT(ResourceCategory.PORT_PARTITION_ENFORCEMENT, null, null, PortPartitionEnforcementProcessor.class),
    FLIT_CTRL_INTERLEAVE(ResourceCategory.FLIT_CTRL_INTERLEAVE, STLConstants.K0763_INTERLEAVE.getValue(), null, FlitControlInterleaveProcessor.class),
    FLIT_CTRL_PREEMPTION(ResourceCategory.FLIT_CTRL_PREEMPTION, STLConstants.K0764_PREEMPTION.getValue(), null, FlitControlPreemptionProcessor.class),
    VIRTUAL_LANE(ResourceCategory.VIRTUAL_LANE, null, null, VirtualLaneProcessor.class),
    SWITCH_INFO(ResourceCategory.SWITCH_INFO, STLConstants.K0437_SWITCH_PROPERTIES.getValue(), null, SwitchInfoProcessor.class),
    SWITCH_FORWARDING(ResourceCategory.SWITCH_FORWARDING, STLConstants.K0435_FORWARDING_INFO.getValue(), null, ForwardingInfoProcessor.class),
    SWITCH_ROUTING(ResourceCategory.SWITCH_ROUTING, STLConstants.K0439_ROUTING_MODE.getValue(), null, SwitchRoutingProcessor.class),
    SWITCH_IPADDR(ResourceCategory.SWITCH_IPADDR, STLConstants.K0440_IP_ADDR.getValue(), null, SwitchIPAddressProcessor.class),
    SWITCH_PARTITION_ENFORCEMENT(ResourceCategory.SWITCH_PARTITION_ENFORCEMENT, STLConstants.K0302_PORT_PART_ENFORCE_TITLE.getValue(), null, SwitchPartitionEnforcementProcessor.class),
    SWITCH_ADAPTIVE_ROUTING(ResourceCategory.SWITCH_ADAPTIVE_ROUTING, STLConstants.K0443_ADAPTIVE_ROUTING.getValue(), null, AdaptiveRoutingProcessor.class),
    MFT_TABLE(ResourceCategory.MFT_TABLE, STLConstants.K0026_LID.getValue(), STLConstants.K0058_PORT_MASK.getValue(), MFTTableProcessor.class),
    LFT_HISTOGRAM(ResourceCategory.LFT_HISTOGRAM, null, null, LFTSeriesProcessor.class),
    LFT_TABLE(ResourceCategory.LFT_TABLE, STLConstants.K0026_LID.getValue(), STLConstants.K0327_PORT_INDEX.getValue(), LFTTableProcessor.class),
    MTU_CHART(ResourceCategory.MTU_CHART, null, null, MTUByVLProcessor.class),
    HOQLIFE_CHART(ResourceCategory.HOQLIFE_CHART, null, null, HoQLifeProcessor.class),
    VL_STALL_CHART(ResourceCategory.VL_STALL_CHART, null, null, VLStallCountByVLProcessor.class),
    CABLE_INFO(ResourceCategory.CABLE_INFO, null, null, CableInfoProcessor.class),
    SC2SLMT_CHART(ResourceCategory.SC2SLMT_CHART, null, null, SC2SLMTProcessor.class),
    SC2VLTMT_CHART(ResourceCategory.SC2VLTMT_CHART, null, null, SC2VLTMTProcessor.class),
    SC2VLNTMT_CHART(ResourceCategory.SC2VLNTMT_CHART, null, null, SC2VLNTMTProcessor.class),
    LINK_DOWN_ERROR_LOG(ResourceCategory.LINK_DOWN_ERROR_LOG, STLConstants.K0401_TIME.getValue(), STLConstants.K0490_LINK_DOWN_REASON.getValue(), LinkDownErrorLogProcessor.class),
    NEIGHBOR_LINK_DOWN_ERROR_LOG(ResourceCategory.NEIGHBOR_LINK_DOWN_ERROR_LOG, STLConstants.K0401_TIME.getValue(), STLConstants.K1300_NEIGHBOR_LINKDOWN_REASON.getValue(), NeighborLinkDownErrorLogProcessor.class);

    private static final EnumMap<ResourceCategory, ResourceCategoryMap> resourceCategoryMap;
    private final ResourceCategory resourceCategory;
    private final String defaultKeyHeader;
    private final String defaultValueHeader;
    private final Class<? extends ResourceCategoryProcessor> processor;
    private ResourceCategoryProcessor processorInstance;

    private ResourceCategoryMap(ResourceCategory category, String defaultKeyHeader, String defaultValueHeader, Class<? extends ResourceCategoryProcessor> processor) {
        this.resourceCategory = category;
        this.defaultKeyHeader = defaultKeyHeader;
        this.defaultValueHeader = defaultValueHeader;
        this.processor = processor;
    }

    public ResourceCategory getResourceCategory() {
        return this.resourceCategory;
    }

    public String getDefaultKeyHeader() {
        return this.defaultKeyHeader;
    }

    public String getDefaultValueHeader() {
        return this.defaultValueHeader;
    }

    public ResourceCategoryProcessor getProcessor() {
        if (this.processorInstance == null) {
            try {
                this.processorInstance = this.processor.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return this.processorInstance;
    }

    public static ResourceCategoryMap getResourceCategoryMapFor(ResourceCategory resourceCategory) {
        return resourceCategoryMap.get((Object)resourceCategory);
    }

    static {
        resourceCategoryMap = new EnumMap(ResourceCategory.class);
        for (ResourceCategoryMap rcm : ResourceCategoryMap.values()) {
            resourceCategoryMap.put(rcm.resourceCategory, rcm);
        }
    }
}

