/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.SC2SLMTRecordBean;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import java.util.ArrayList;

public class SC2SLMTProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        int lid;
        FVResourceNode node = context.getResourceNode();
        ISubnetApi subnetApi = context.getContext().getSubnetApi();
        SC2SLMTRecordBean sc2slmtRec = subnetApi.getSC2SLMT(lid = node.getId());
        if (sc2slmtRec == null) {
            return;
        }
        this.getSC2SLMT(category, sc2slmtRec.getData());
    }

    private void getSC2SLMT(DevicePropertyCategory category, byte[] sc2sl) {
        ArrayList<Double> sc2slSeries = new ArrayList<Double>();
        for (int i = 0; i < sc2sl.length; ++i) {
            String doubleValue = SC2SLMTProcessor.dec((short)(sc2sl[i] & 0xFF));
            sc2slSeries.add(Double.parseDouble(doubleValue));
        }
        double[] series = new double[sc2slSeries.size()];
        for (int i = 0; i < sc2slSeries.size(); ++i) {
            series[i] = (Double)sc2slSeries.get(i);
        }
        DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.SL, (Object)series);
        category.addPropertyItem(property);
        DevicePropertyItem sc = new DevicePropertyItem(DeviceProperty.SC, (Object)new Integer(32));
        category.addPropertyItem(sc);
    }
}

