/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.SwitchInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class SwitchInfoProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        SwitchInfoBean switchInfo = context.getSwitchInfo();
        if (switchInfo == null) {
            this.getEmptySwitchDeviceInfo(category);
            return;
        }
        if (switchInfo.isEnhancedPort0()) {
            SwitchInfoProcessor.addProperty(category, DeviceProperty.ENH_SWITCH_PORT0, STLConstants.K0385_TRUE.getValue());
        } else {
            SwitchInfoProcessor.addProperty(category, DeviceProperty.ENH_SWITCH_PORT0, STLConstants.K0386_FALSE.getValue());
        }
        SwitchInfoProcessor.addProperty(category, DeviceProperty.LIFETIME_VALUE, SwitchInfoProcessor.dec(switchInfo.getLifeTimeValue()));
        int portStateChange = 0;
        if (switchInfo.isPortStateChange()) {
            portStateChange = 1;
        }
        SwitchInfoProcessor.addProperty(category, DeviceProperty.PORT_STATE_CHANGE, SwitchInfoProcessor.dec(portStateChange));
    }

    private void getEmptySwitchDeviceInfo(DevicePropertyCategory category) {
        SwitchInfoProcessor.addProperty(category, DeviceProperty.ENH_SWITCH_PORT0, "");
        SwitchInfoProcessor.addProperty(category, DeviceProperty.LIFETIME_VALUE, "");
        SwitchInfoProcessor.addProperty(category, DeviceProperty.PORT_STATE_CHANGE, "");
    }
}

