/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.configuration.MultiColumnCategoryController;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.framework.AbstractView;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultiColumnCategoryPanel
extends AbstractView<DevicePropertyCategory, MultiColumnCategoryController> {
    private static final long serialVersionUID = 1L;
    protected JPanel mainPanel;
    protected JPanel pagePanel;
    protected GroupLayout layout;
    protected DevicePropertyCategory model;
    private final int numCols;
    private final PropertyVizStyle style;

    public MultiColumnCategoryPanel(int numCols, PropertyVizStyle style) {
        if (numCols <= 0) {
            throw new IllegalArgumentException("Invalid number of columns: " + numCols);
        }
        this.numCols = numCols;
        this.style = style;
    }

    @Override
    public void modelUpdateFailed(DevicePropertyCategory model, Throwable caught) {
    }

    @Override
    public void modelChanged(DevicePropertyCategory model) {
        this.model = model;
        this.displayPage(0, model.size());
    }

    @Override
    public JComponent getMainComponent() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mainPanel.setBackground(UIConstants.INTEL_WHITE);
        return this.mainPanel;
    }

    @Override
    public void initComponents() {
        this.createPagePanel();
        this.mainPanel.add(this.pagePanel);
    }

    protected void createPagePanel() {
        this.pagePanel = new JPanel();
        this.layout = new GroupLayout(this.pagePanel);
        this.pagePanel.setLayout(this.layout);
        this.pagePanel.setBackground(UIConstants.INTEL_WHITE);
    }

    protected void displayPage(int start, int numLines) {
        String keyHeader = this.model.getKeyHeader();
        String valHeader = this.model.getValueHeader();
        if (keyHeader == null || keyHeader.length() == 0) {
            this.displayPage(start, numLines, null, null);
        } else {
            if (valHeader == null) {
                valHeader = "";
            }
            this.displayPage(start, numLines, keyHeader, valHeader);
        }
    }

    protected void displayPage(int start, int numLines, String keyHeader, String valueHeader) {
        boolean showHeaders = false;
        if (keyHeader != null) {
            showHeaders = true;
        }
        int itemsPerColumn = (numLines + (this.numCols - 1)) / this.numCols;
        this.pagePanel.removeAll();
        GroupLayout.SequentialGroup hGroup = this.layout.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup = this.layout.createSequentialGroup();
        GroupLayout.ParallelGroup headerRow = null;
        GroupLayout.ParallelGroup[] row = new GroupLayout.ParallelGroup[itemsPerColumn];
        if (showHeaders) {
            headerRow = this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            vGroup.addGroup(headerRow);
        }
        for (int i = 0; i < itemsPerColumn; ++i) {
            row[i] = this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            vGroup.addGroup(row[i]);
        }
        List items = this.model.getList();
        int size = this.model.size();
        int offset = start;
        int itemCt = 0;
        ArrayList<JLabel> keys = new ArrayList<JLabel>();
        ArrayList<JLabel> values = new ArrayList<JLabel>();
        for (int i = 0; i < this.numCols; ++i) {
            GroupLayout.ParallelGroup keyCol = this.layout.createParallelGroup(GroupLayout.Alignment.LEADING);
            GroupLayout.ParallelGroup valCol = this.layout.createParallelGroup(GroupLayout.Alignment.LEADING);
            hGroup.addGap(5);
            hGroup.addGroup(keyCol);
            hGroup.addGroup(valCol);
            hGroup.addGap(5);
            keys.clear();
            values.clear();
            if (showHeaders) {
                JLabel keyTitle = this.createHeaderKey(keyHeader, 0);
                keyTitle.setName((Object)((Object)WidgetName.PM_PROP_HEADER_NAME_) + keyHeader);
                keys.add(keyTitle);
                JLabel valTitle = this.createHeaderValue(valueHeader);
                valTitle.setName((Object)((Object)WidgetName.PM_PROP_HEADER_VALUE_) + keyHeader);
                values.add(valTitle);
                headerRow.addComponent(keyTitle);
                headerRow.addComponent(valTitle);
                keyCol.addComponent(keyTitle);
                valCol.addComponent(valTitle);
            }
            for (int j = 0; j < itemsPerColumn; ++j) {
                if (itemCt < numLines && offset < size) {
                    DevicePropertyItem item = (DevicePropertyItem)items.get(offset);
                    JLabel key = this.createKey(item.getLabel(), j);
                    key.setName((Object)((Object)WidgetName.PM_PROP_ITEM_NAME_) + item.getLabel());
                    keys.add(key);
                    JLabel value = this.createValue(item.getValue(), j);
                    value.setName((Object)((Object)WidgetName.PM_PROP_ITEM_VALUE_) + item.getLabel());
                    values.add(value);
                    row[j].addComponent(key);
                    row[j].addComponent(value);
                    keyCol.addComponent(key);
                    valCol.addComponent(value);
                }
                ++itemCt;
                ++offset;
            }
            this.layout.linkSize(0, keys.toArray(new Component[0]));
            this.layout.linkSize(0, values.toArray(new Component[0]));
        }
        this.layout.setHorizontalGroup(hGroup);
        this.layout.setVerticalGroup(vGroup);
        this.pagePanel.repaint();
    }

    protected JLabel createKey(String text, int row) {
        JLabel label = ComponentFactory.getH4Label(text, 0);
        label.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 3));
        this.style.decorateKey(label, row);
        return label;
    }

    protected JLabel createValue(String text, int row) {
        JLabel label = ComponentFactory.getH4Label(text, 0);
        label.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 2));
        this.style.decorateValue(label, row);
        return label;
    }

    protected JLabel createHeaderKey(String text, int row) {
        JLabel label = ComponentFactory.getH4Label(text, 0);
        this.style.decorateHeaderKey(label, row);
        return label;
    }

    protected JLabel createHeaderValue(String text) {
        JLabel label = ComponentFactory.getH4Label(text, 0);
        this.style.decorateHeaderValue(label);
        return label;
    }
}

