/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.configuration.view.MultiColumnCategoryPanel;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.model.DevicePropertyCategory;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;

public class PagingCategoryPanel
extends MultiColumnCategoryPanel {
    private static final long serialVersionUID = 1L;
    private JPanel pagingPanel;
    private int start;
    private int totalPages;
    private JButton leftArrow;
    private JButton rightArrow;
    private JButton[] pageButtons;
    private final int itemsPerPage;
    private final int centerButtons;
    private final int numButtons;
    private final int slots;

    public PagingCategoryPanel(int numCols, int itemsPerPage, int centerButtons, PropertyVizStyle style) {
        super(numCols, style);
        this.itemsPerPage = itemsPerPage;
        this.centerButtons = centerButtons;
        this.numButtons = centerButtons + 4;
        this.slots = this.numButtons + 2;
    }

    @Override
    public void modelChanged(DevicePropertyCategory model) {
        this.model = model;
        this.start = 0;
        this.totalPages = (model.size() + (this.itemsPerPage - 1)) / this.itemsPerPage;
        this.displayPage(this.start, this.itemsPerPage);
        this.resetPagingButtons();
    }

    @Override
    public void initComponents() {
        this.createPagePanel();
        this.createPagingPanel();
        this.mainPanel.add(this.pagePanel);
        this.mainPanel.add(this.pagingPanel);
    }

    private void resetPagingButtons() {
        this.resetButtons();
        if (this.totalPages <= this.numButtons) {
            this.resetNormalPagingButtons();
        } else {
            this.resetSlidingPagingButtons();
        }
    }

    private void resetNormalPagingButtons() {
        int i;
        int currPage = this.start / this.itemsPerPage + 1;
        this.resetArrowButtons(currPage);
        int skip = (this.numButtons - this.totalPages) / 2;
        for (int i2 = 0; i2 < skip; ++i2) {
            this.pageButtons[i2].setText("");
        }
        int pageNum = 1;
        for (i = skip; i < skip + this.totalPages; ++i) {
            this.pageButtons[i].setText(Integer.toString(pageNum));
            ++pageNum;
        }
        for (i = skip + this.totalPages; i < this.numButtons; ++i) {
            this.pageButtons[i].setText("");
            ++pageNum;
        }
        this.pageButtons[skip + currPage - 1].setBackground(UIConstants.INTEL_PALE_BLUE);
    }

    private void resetSlidingPagingButtons() {
        int currPage = this.start / this.itemsPerPage + 1;
        this.resetArrowButtons(currPage);
        if (currPage <= this.centerButtons) {
            this.resetLastPageButtons();
            for (int i = 0; i < this.numButtons - 2; ++i) {
                this.pageButtons[i].setText(Integer.toString(i + 1));
            }
            this.pageButtons[currPage - 1].setBackground(UIConstants.INTEL_PALE_BLUE);
        } else if (currPage >= this.totalPages - this.centerButtons - 1) {
            this.resetFirtPageButtons();
            int pageNum = this.totalPages - this.centerButtons - 1;
            for (int i = 2; i < this.numButtons; ++i) {
                this.pageButtons[i].setText(Integer.toString(pageNum));
                if (pageNum == currPage) {
                    this.pageButtons[i].setBackground(UIConstants.INTEL_PALE_BLUE);
                }
                ++pageNum;
            }
        } else {
            this.resetFirtPageButtons();
            this.resetLastPageButtons();
            int beforeCurrPage = (this.centerButtons - 1) / 2;
            int pageNum = currPage - beforeCurrPage;
            for (int i = 2; i < this.numButtons - 2; ++i) {
                this.pageButtons[i].setText(Integer.toString(pageNum));
                if (pageNum == currPage) {
                    this.pageButtons[i].setBackground(UIConstants.INTEL_PALE_BLUE);
                }
                ++pageNum;
            }
        }
    }

    private void resetFirtPageButtons() {
        this.pageButtons[0].setText(Integer.toString(1));
        this.pageButtons[1].setText("...");
        this.pageButtons[1].setEnabled(false);
    }

    private void resetLastPageButtons() {
        this.pageButtons[this.numButtons - 2].setText("...");
        this.pageButtons[this.numButtons - 2].setEnabled(false);
        this.pageButtons[this.numButtons - 1].setText(Integer.toString(this.totalPages));
    }

    private void resetArrowButtons(int currPage) {
        if (currPage == 1) {
            this.leftArrow.setEnabled(false);
            this.rightArrow.setEnabled(true);
        } else if (currPage == this.totalPages) {
            this.leftArrow.setEnabled(true);
            this.rightArrow.setEnabled(false);
        } else {
            this.leftArrow.setEnabled(true);
            this.rightArrow.setEnabled(true);
        }
    }

    private void resetButtons() {
        for (int i = 0; i < this.numButtons; ++i) {
            this.pageButtons[i].setBackground(UIConstants.INTEL_WHITE);
            this.pageButtons[i].setEnabled(true);
        }
    }

    private void createPagingPanel() {
        this.pagingPanel = new JPanel();
        this.pagingPanel.setLayout(new GridLayout(1, this.slots));
        this.pagingPanel.setBackground(UIConstants.INTEL_WHITE);
        MouseAdapter cursorChanger = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        this.pageButtons = new JButton[this.numButtons];
        this.leftArrow = this.getPlainButton();
        this.leftArrow.setMargin(new Insets(3, 5, 3, 4));
        this.leftArrow.setIcon(UIImages.BACK_BLUE_ICON.getImageIcon());
        this.leftArrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int currPage = PagingCategoryPanel.this.start / PagingCategoryPanel.this.itemsPerPage + 1;
                PagingCategoryPanel.this.skipToPage(currPage - 1);
            }
        });
        this.leftArrow.addMouseListener(cursorChanger);
        this.pagingPanel.add(this.leftArrow);
        for (int i = 0; i < this.numButtons; ++i) {
            this.pageButtons[i] = this.getPlainButton();
            this.pageButtons[i].setMargin(new Insets(3, 4, 3, 4));
            this.pageButtons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String pageNum = ((JButton)e.getSource()).getText();
                    try {
                        int num = Integer.parseInt(pageNum);
                        PagingCategoryPanel.this.skipToPage(num);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.pageButtons[i].addMouseListener(cursorChanger);
            this.pagingPanel.add(this.pageButtons[i]);
        }
        this.rightArrow = this.getPlainButton();
        this.rightArrow.setIcon(UIImages.FORWARD_BLUE_ICON.getImageIcon());
        this.rightArrow.setMargin(new Insets(3, 4, 3, 5));
        this.rightArrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int currPage = PagingCategoryPanel.this.start / PagingCategoryPanel.this.itemsPerPage + 1;
                PagingCategoryPanel.this.skipToPage(currPage + 1);
            }
        });
        this.rightArrow.addMouseListener(cursorChanger);
        this.pagingPanel.add(this.rightArrow);
        this.pagingPanel.repaint();
    }

    private void skipToPage(int pageNum) {
        if (pageNum > 0 && pageNum <= this.totalPages) {
            this.start = (pageNum - 1) * this.itemsPerPage;
            this.displayPage(this.start, this.itemsPerPage);
            this.resetPagingButtons();
        }
    }

    private JButton getPlainButton() {
        JButton btn = new JButton();
        btn.setUI(new BasicButtonUI());
        btn.setBackground(Color.WHITE);
        btn.setForeground(Color.BLACK);
        return btn;
    }
}

