/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.configuration.view.PropertyCategoryPanel;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.model.IPropertyCategory;
import com.intel.stl.ui.model.PropertyGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PropertyGroupPanel<C extends IPropertyCategory<?>, G extends PropertyGroup<C>>
extends JCardView<ICardListener> {
    private static final long serialVersionUID = 1L;
    protected JPanel totalPanel;
    private JPanel propCardPanel;
    private final PropertyVizStyle style;

    public PropertyGroupPanel(PropertyVizStyle style) {
        this(style, "");
    }

    public PropertyGroupPanel(PropertyVizStyle style, String title) {
        super(title);
        this.style = style;
        this.getMainComponent();
    }

    public PropertyVizStyle getStyle() {
        return this.style;
    }

    public void setModel(G model) {
        this.setName((Object)((Object)WidgetName.PM_PROP_GROUP_) + ((PropertyGroup)model).getGroupName());
        this.setTitle(((PropertyGroup)model).getGroupName());
        this.propCardPanel.removeAll();
        int row = 0;
        for (IPropertyCategory category : ((PropertyGroup)model).getPropertyCategories()) {
            this.addCategory(category, row);
            ++row;
        }
        this.propCardPanel.repaint();
        this.validate();
    }

    private void addCategory(C category, int row) {
        Component categoryPanel = this.createCategoryPanel(category, this.style);
        categoryPanel.setName((Object)((Object)WidgetName.PM_PROP_CATEGORY_) + category.getKeyHeader());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 21;
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = row;
        gc.weightx = 1.0;
        int yPadTop = 0;
        int yPadBtm = 2;
        int xPadLeft = 0;
        int xPadRight = 0;
        gc.insets = new Insets(yPadTop, xPadLeft, yPadBtm, xPadRight);
        this.propCardPanel.add(categoryPanel, gc);
    }

    protected Component createCategoryPanel(C category, PropertyVizStyle style) {
        PropertyCategoryPanel panel = new PropertyCategoryPanel(style);
        panel.setModel(category);
        return panel;
    }

    @Override
    public JComponent getMainComponent() {
        if (this.totalPanel == null) {
            this.totalPanel = new JPanel();
            this.totalPanel.setLayout(new BorderLayout());
            this.totalPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.propCardPanel = new JPanel();
            this.propCardPanel.setLayout(new GridBagLayout());
            this.propCardPanel.setBackground(UIConstants.INTEL_WHITE);
            this.totalPanel.add((Component)this.propCardPanel, "North");
        }
        return this.totalPanel;
    }
}

