/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.configuration.view.DevicePropertyCategoryPanel;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import java.awt.Component;
import java.awt.Dimension;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class SC2VLTMTBarChartPanel
extends DevicePropertyCategoryPanel {
    private static final long serialVersionUID = 1L;
    private static final Dimension PREFERRED_CHART_SIZE = new Dimension(360, 240);
    private XYSeriesCollection dataset;
    private ChartPanel chartPanel;

    @Override
    public void modelUpdateFailed(DevicePropertyCategory model, Throwable caught) {
    }

    @Override
    public void modelChanged(DevicePropertyCategory model) {
        double[] values = (double[])model.getProperty(DeviceProperty.VLT).getObject();
        int numSCs = (Integer)model.getProperty(DeviceProperty.SC).getObject();
        XYSeries xyseries = new XYSeries((Comparable)((Object)""));
        int x = 0;
        for (double v : values) {
            xyseries.add((double)x++, v);
        }
        this.dataset.addSeries(xyseries);
        this.chartPanel.getChart().getXYPlot().getDomainAxis().setRange(0.0, (double)numSCs);
    }

    @Override
    public void initComponents() {
        this.dataset = new XYSeriesCollection();
        JFreeChart chart = ComponentFactory.createXYBarChart(STLConstants.K1105_SC.getValue(), STLConstants.K1109_VLT.getValue(), (IntervalXYDataset)this.dataset, null);
        XYPlot plot = chart.getXYPlot();
        plot.setDomainPannable(true);
        plot.setRangePannable(true);
        final String scLabel = "<html>" + STLConstants.K1105_SC.getValue() + ": ";
        final String vltLabel = "<br>" + STLConstants.K1109_VLT.getValue() + ": ";
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        renderer.setBarAlignmentFactor(0.0);
        renderer.setMargin(0.2);
        renderer.setSeriesToolTipGenerator(0, new XYToolTipGenerator(){

            public String generateToolTip(XYDataset dataset, int arg1, int arg2) {
                int scNum = (int)dataset.getXValue(arg1, arg2);
                int vltCount = (int)dataset.getYValue(arg1, arg2);
                return scLabel + scNum + vltLabel + vltCount + "</html>";
            }
        });
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        NumberAxis xAxis = (NumberAxis)plot.getDomainAxis();
        xAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setMouseWheelEnabled(true);
        this.chartPanel.setPreferredSize(PREFERRED_CHART_SIZE);
        this.propsPanel.add((Component)this.chartPanel);
    }
}

