/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console;

import com.intel.stl.api.Utils;
import com.intel.stl.ui.common.IHelp;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.console.IConsole;
import com.intel.stl.ui.console.IConsoleEventListener;
import com.intel.stl.ui.console.IConsoleListener;
import com.intel.stl.ui.console.IConsoleLogin;
import com.intel.stl.ui.console.IConsoleMsgListener;
import com.intel.stl.ui.console.ITty;
import com.intel.stl.ui.console.IntelEmulator;
import com.intel.stl.ui.console.IntelTty;
import com.intel.stl.ui.console.LoginBean;
import com.intel.stl.ui.console.view.ConsoleTerminalView;
import com.intel.stl.ui.console.view.IntelTerminalPanel;
import com.intel.stl.ui.console.view.IntelTerminalView;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.wittams.gritty.BackBuffer;
import com.wittams.gritty.CharacterUtils;
import com.wittams.gritty.Emulator;
import com.wittams.gritty.ScrollBuffer;
import com.wittams.gritty.StyleState;
import com.wittams.gritty.TerminalDisplay;
import com.wittams.gritty.TerminalWriter;
import com.wittams.gritty.Tty;
import com.wittams.gritty.TtyChannel;
import java.awt.Component;
import java.awt.Point;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;

public class ConsoleTerminalController
implements IConsoleListener,
IConsole {
    private static String HIS_CMD_START = "his_cmd_start";
    private static String HIS_CMD_DONE = "his_cmd_done";
    private static String HISTORY_CMD = "echo " + HIS_CMD_START + ";export TMP_HIS=`(history 1 | cut -c 1-7)`; history -d $TMP_HIS; history 32 | cut -c 8-; echo " + HIS_CMD_DONE;
    private static int QUEUE_LIMIT = 100;
    private final IntelTerminalView terminal;
    private Thread processingThread = null;
    private final BlockingQueue<String> messageQueue;
    private String command = null;
    private LoginBean loginBean;
    private final ConsoleTerminalView consoleTerminalView;
    private String helpID;
    private String pageName;
    private final String pageDescription;
    private IConsoleEventListener consoleEventListener;
    private final IHelp consoleHelpListener;
    private final ConsoleTerminalController cnslTermCtrl = this;
    private IConsoleLogin consoleLogin;
    private ITty tty;
    private final int id;
    private Session lastSession;
    private boolean initialized;
    private String prompt;
    private boolean promptReady;
    private String lastCommand = "";

    public ConsoleTerminalController(ConsoleTerminalView view, String pageName, String pageDescription, int id, IHelp consoleHelpListener) {
        this.consoleTerminalView = view;
        this.installHelp();
        this.consoleLogin = this.consoleTerminalView.getConsoleLogin();
        this.pageName = pageName;
        this.pageDescription = pageDescription;
        this.id = id;
        this.consoleHelpListener = consoleHelpListener;
        this.terminal = new IntelTerminalView(this, consoleHelpListener.getTopicIdList(), this.cnslTermCtrl);
        view.setTermPanel(this.terminal);
        this.messageQueue = new ArrayBlockingQueue<String>(QUEUE_LIMIT);
        this.consoleTerminalView.setConsoleListener(this);
    }

    protected void installHelp() {
        String helpId = this.getHelpID();
        if (helpId != null) {
            this.consoleTerminalView.enableHelp(true);
            HelpAction helpAction = HelpAction.getInstance();
            helpAction.getHelpBroker().enableHelpOnButton((Component)this.consoleTerminalView.getHelpButton(), helpId, helpAction.getHelpSet());
        } else {
            this.consoleTerminalView.enableHelp(false);
        }
    }

    @Override
    public synchronized String getLastCommand() {
        return this.lastCommand;
    }

    @Override
    public synchronized void setLastCommand(String lastCommand) {
        this.lastCommand = lastCommand;
    }

    public String getHelpID() {
        return HelpAction.getInstance().getAdminConsoleTerminal();
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
    }

    @Override
    public String getName() {
        return this.pageName;
    }

    public void setName(String name) {
        this.pageName = name;
    }

    @Override
    public String getDescription() {
        return this.pageDescription;
    }

    @Override
    public Component getView() {
        return this.consoleTerminalView;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void clear() {
    }

    public LoginBean getLoginInfo() {
        return this.loginBean;
    }

    @Override
    public void initializeTerminal(LoginBean loginBean) throws NumberFormatException {
        this.loginBean = loginBean;
        if (loginBean != null) {
            this.tty = new IntelTty(loginBean, null);
            this.terminal.setTty(this.tty);
            this.terminal.start();
            this.processingThread();
        }
    }

    @Override
    public void initializeTerminal(LoginBean loginBean, String command) {
        this.command = command;
        this.loginBean = loginBean;
        this.tty = new IntelTty(loginBean, null);
        this.tty.setSession(loginBean.getSession());
        this.terminal.setTty(this.tty);
        this.terminal.start();
        this.processingThread();
        this.consoleTerminalView.addCommand(command);
    }

    @Override
    public void addNewConsole(String command) {
        this.consoleEventListener.addNewConsole(this.loginBean, false, command);
    }

    @Override
    public void shutDownConsole() {
        this.addToQueue("exit");
    }

    @Override
    public void updatePersonalizedTab(String command) {
        this.consoleEventListener.updatePersonalizedTab(this.loginBean, command);
    }

    public String toString() {
        String loginBeanStr = this.loginBean == null ? "loginBean is null!" : this.loginBean.toString();
        return super.toString() + loginBeanStr + "]";
    }

    public void setNewConsoleListener(IConsoleEventListener listener) {
        this.consoleEventListener = listener;
    }

    @Override
    public void updateInfoPanel(final LoginBean loginBean) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                ConsoleTerminalController.this.consoleTerminalView.setHostName(loginBean.getHostName());
                ConsoleTerminalController.this.consoleTerminalView.setPortNum(loginBean.getPortNum());
                ConsoleTerminalController.this.consoleTerminalView.setUserName(loginBean.getUserName());
            }
        });
    }

    @Override
    public void addToQueue(final String command) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                try {
                    if (command != null) {
                        ConsoleTerminalController.this.messageQueue.put(command);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void onLock(boolean isSelected) {
        if (isSelected) {
            this.lastSession = this.tty.getSession();
        }
    }

    @Override
    public void onUnlock(char[] pw) throws JSchException {
        boolean success = this.authenticateSession(pw);
        if (success) {
            this.consoleTerminalView.toggleLock(true);
            this.consoleLogin.killProgress();
            this.consoleLogin.hideLogin();
        }
    }

    @Override
    public void showLoginPanel() {
        LoginBean loginBean = new LoginBean(this.lastSession.getUserName(), this.lastSession.getHost(), String.valueOf(this.lastSession.getPort()));
        this.consoleLogin.showLogin(loginBean, false, this.id);
    }

    @Override
    public void hideLoginPanel() {
        this.consoleLogin.hideLogin();
    }

    @Override
    public boolean authenticateSession(char[] pw) throws JSchException {
        boolean connected = false;
        String userName = this.lastSession.getUserName();
        String hostName = this.lastSession.getHost();
        int portNum = this.lastSession.getPort();
        JSch jsch = Utils.createJSch();
        Session session = jsch.getSession(userName, hostName, portNum);
        if (session != null) {
            session.setPassword(new String(pw));
            session.connect();
            connected = session.isConnected();
        }
        return connected;
    }

    @Override
    public IConsoleLogin getConsoleLogin() {
        this.consoleLogin = this.consoleEventListener.getConsoleLogin();
        return this.consoleLogin;
    }

    @Override
    public void onConnect(boolean sessionRunning) {
        boolean connected;
        boolean bl = connected = sessionRunning && this.tty.isConnected();
        if (connected) {
            this.addToQueue(this.command);
            this.loginBean.setSession(this.tty.getSession());
        }
        this.consoleEventListener.onConnect(connected, this.command);
    }

    @Override
    public void onConnectFail(Exception e) {
        this.consoleEventListener.onConnectFail(this, 1, e);
    }

    public void sendCommand(String command) {
        if (this.terminal != null && command != null) {
            try {
                this.terminal.sendCommand(command + new String(CharacterUtils.getCode((int)10)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isConnected() {
        return this.terminal.isSessionRunning();
    }

    public void processingThread() {
        if (this.terminal != null) {
            this.processingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (ConsoleTerminalController.this.processingThread != null) {
                        try {
                            ConsoleTerminalController.this.command = (String)ConsoleTerminalController.this.messageQueue.take();
                            if (ConsoleTerminalController.this.command == null) continue;
                            if (ConsoleTerminalController.this.command.compareTo("exit") == 0) {
                                ConsoleTerminalController.this.terminal.stop();
                                ConsoleTerminalController.this.processingThread = null;
                                ConsoleTerminalController.this.command = null;
                                System.out.println("Terminal " + ConsoleTerminalController.this.id + " terminated!");
                                continue;
                            }
                            ConsoleTerminalController.this.sendCommand(ConsoleTerminalController.this.command);
                        }
                        catch (InterruptedException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
            });
        }
        if (this.processingThread != null && !this.processingThread.isAlive()) {
            this.processingThread.start();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setCursor(Point position) {
        this.terminal.setTerminalCursor(position);
    }

    @Override
    public IHelp getHelpController() {
        return this.consoleHelpListener;
    }

    @Override
    public Session getSession() {
        return this.tty.getSession();
    }

    public ITty getTty() {
        return this.tty;
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public IntelTerminalView getTerminal() {
        return this.terminal;
    }

    @Override
    public void closeSession() {
        this.consoleEventListener.closeSession(this);
    }

    @Override
    public void terminalStopped() {
        this.consoleEventListener.terminalStopped(this.id);
    }

    @Override
    public boolean isConsoleAllowed() {
        return this.consoleEventListener.isConsoleAllowed(this);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean b) {
        this.initialized = b;
    }

    @Override
    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @Override
    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public void setPromptReady(boolean b) {
        this.promptReady = b;
    }

    @Override
    public boolean isPromptReady() {
        return this.promptReady;
    }

    public class ConsoleInitializer
    implements IConsoleMsgListener {
        private String response = new String();
        private ITty initTty = null;
        private final AtomicBoolean running = new AtomicBoolean();
        private Emulator initEmulator;
        private Thread emulatorThread;
        private boolean done = false;

        @Override
        public void storeCmdResult(int bytesAvailable, int numBytesRead, byte[] buf) {
            String[] cmds;
            if (!this.done) {
                try {
                    String inputStr = new String(buf, "UTF-8");
                    if (numBytesRead <= inputStr.length()) {
                        this.response = this.response + inputStr.substring(0, numBytesRead);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                try {
                    cmds = this.response.split("\r\n");
                    if (bytesAvailable <= 0) {
                        if (cmds.length >= 2) {
                            this.done = cmds[cmds.length - 2].equals(HIS_CMD_DONE);
                        } else {
                            this.response = "";
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            if (this.done) {
                this.initTty.enableMsgListener(false);
                ConsoleTerminalController.this.consoleTerminalView.setCmdFieldEnable(false);
                cmds = this.response.split("\r\n");
                boolean cmdStarted = false;
                for (int i = 0; i < cmds.length - 2; ++i) {
                    if (!cmdStarted && cmds[i].equals(HIS_CMD_START)) {
                        cmdStarted = true;
                        continue;
                    }
                    if (!cmdStarted) continue;
                    ConsoleTerminalController.this.consoleTerminalView.addCommand(cmds[i]);
                }
                if (this.emulatorThread != null) {
                    this.emulatorThread.interrupt();
                    this.emulatorThread = null;
                }
                ConsoleTerminalController.this.consoleTerminalView.setCmdFieldEnable(true);
                ConsoleTerminalController.this.setInitialized(true);
            }
        }

        @Override
        public void initializeCommands(LoginBean loginBean) throws NumberFormatException, JSchException {
            boolean connected = false;
            TtyChannel channel = null;
            LoginBean bean = new LoginBean(loginBean);
            bean.setPassword(loginBean.getPassword());
            JSch jsch = Utils.createJSch();
            Session session = jsch.getSession(bean.getUserName(), bean.getHostName(), Integer.valueOf(bean.getPortNum()).intValue());
            bean.setSession(session);
            if (bean != null) {
                this.initTty = new IntelTty(bean, this);
                channel = new TtyChannel((Tty)this.initTty);
                StyleState styleState = new StyleState();
                BackBuffer backBuffer = new BackBuffer(80, 24, styleState);
                ScrollBuffer scrollBuffer = new ScrollBuffer();
                IntelTerminalPanel termPanel = new IntelTerminalPanel(backBuffer, scrollBuffer, styleState, ConsoleTerminalController.this.consoleHelpListener, ConsoleTerminalController.this.cnslTermCtrl);
                termPanel.setCursor(0, 0);
                TerminalWriter terminalWriter = new TerminalWriter((TerminalDisplay)termPanel, backBuffer, styleState);
                this.initEmulator = new IntelEmulator(terminalWriter, channel);
                if (!connected) {
                    this.emulatorThread = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Thread.currentThread().setName(ConsoleInitializer.this.initTty.getName());
                                if (ConsoleInitializer.this.initTty.initialize()) {
                                    Thread.currentThread().setName(ConsoleTerminalController.this.tty.getName());
                                    ConsoleInitializer.this.running.set(true);
                                    ConsoleInitializer.this.onConnect(ConsoleInitializer.this.running.get());
                                    ConsoleInitializer.this.initEmulator.start();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            finally {
                                ConsoleInitializer.this.running.set(false);
                                ConsoleInitializer.this.initTty.close();
                            }
                        }
                    });
                    this.emulatorThread.start();
                }
            }
        }

        public void onConnect(boolean connected) {
            if (connected) {
                ConsoleTerminalController.this.consoleTerminalView.addCommand("");
                this.done = false;
                this.response = "";
                this.initTty.enableMsgListener(true);
                try {
                    String commandToSend = new String(HISTORY_CMD + new String(CharacterUtils.getCode((int)10)));
                    Thread.sleep(500L);
                    this.initTty.write(commandToSend.getBytes());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

