/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console;

import com.intel.stl.api.Utils;
import com.intel.stl.ui.console.ConsoleLogger;
import com.intel.stl.ui.console.IConsoleMsgListener;
import com.intel.stl.ui.console.ITty;
import com.intel.stl.ui.console.IntelUserInfo;
import com.intel.stl.ui.console.LoginBean;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.wittams.gritty.Questioner;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Properties;

public class IntelTty
implements ITty {
    private InputStream in = null;
    private OutputStream out = null;
    private Session session;
    private ChannelShell channel;
    private int port = 22;
    private String user = null;
    private String host = null;
    private char[] password = null;
    private Dimension pendingTermSize;
    private Dimension pendingPixelSize;
    private final IConsoleMsgListener messageListener;
    private boolean enableMsgListener = false;

    public IntelTty(LoginBean loginBean, IConsoleMsgListener messageListener) throws NumberFormatException {
        this.host = loginBean.getHostName();
        this.user = loginBean.getUserName();
        this.password = loginBean.getPassword();
        this.messageListener = messageListener;
        this.port = Integer.parseInt(loginBean.getPortNum());
    }

    public void resize(Dimension termSize, Dimension pixelSize) {
        this.pendingTermSize = termSize;
        this.pendingPixelSize = pixelSize;
        if (this.channel != null) {
            this.resizeImmediately();
        }
    }

    private void resizeImmediately() {
        if (this.pendingTermSize != null && this.pendingPixelSize != null) {
            this.channel.setPtySize(this.pendingTermSize.width, this.pendingTermSize.height, this.pendingPixelSize.width, this.pendingPixelSize.height);
            this.pendingTermSize = null;
            this.pendingPixelSize = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
            if (this.channel != null) {
                this.channel.disconnect();
                this.channel = null;
            }
            try {
                this.in.close();
                this.in = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.out.close();
                    this.out = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void closeChannel() {
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel = null;
        }
    }

    @Override
    public boolean initialize() throws Exception {
        if (this.session == null || !this.session.isConnected()) {
            this.session = this.connectSession();
        }
        this.channel = (ChannelShell)this.session.openChannel("shell");
        this.in = this.channel.getInputStream();
        this.out = this.channel.getOutputStream();
        this.channel.connect();
        this.resizeImmediately();
        return true;
    }

    private Session connectSession() throws JSchException {
        JSch.setLogger((Logger)new ConsoleLogger());
        JSch jsch = Utils.createJSch();
        Session session = jsch.getSession(this.user, this.host, this.port);
        IntelUserInfo ui = new IntelUserInfo();
        if (this.password != null) {
            session.setPassword(new String(this.password));
            ui.setPassword(this.password);
        }
        session.setUserInfo((UserInfo)ui);
        Properties config = new Properties();
        config.put("compression.s2c", "zlib,none");
        config.put("compression.c2s", "zlib,none");
        this.configureSession(session, config);
        session.setTimeout(5000);
        session.connect();
        session.setTimeout(0);
        return session;
    }

    protected void configureSession(Session session, Properties config) {
        session.setConfig(config);
    }

    public String getName() {
        return "ConnectRunnable";
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        int res = this.in.read(buf, offset, length);
        if (this.enableMsgListener) {
            this.messageListener.storeCmdResult(this.in.available(), res, buf);
        }
        if (res < 0) {
            throw new InterruptedIOException();
        }
        return res;
    }

    public void write(byte[] bytes) throws IOException {
        if (this.out != null) {
            this.out.write(bytes);
            this.out.flush();
        }
    }

    @Override
    public boolean isConnected() {
        boolean isConnected = false;
        if (this.session != null) {
            isConnected = this.session.isConnected();
        }
        return isConnected;
    }

    public boolean init(Questioner q) {
        return false;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public boolean isEnableMsgListener() {
        return this.enableMsgListener;
    }

    @Override
    public void enableMsgListener(boolean enableMsgListener) {
        this.enableMsgListener = enableMsgListener;
    }
}

