/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.framework;

import com.intel.stl.ui.framework.BackgroundWorker;
import com.intel.stl.ui.framework.IController;
import com.intel.stl.ui.framework.ITask;
import com.intel.stl.ui.main.Context;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractTask<M, T, V>
implements ITask {
    protected final M model;
    private final BackgroundWorker<T, V> worker;
    private final PropertyChangeSupport support;
    private IController controller;
    private final AtomicBoolean submitted = new AtomicBoolean(false);

    public AbstractTask(M model) {
        this.model = model;
        this.worker = new BackgroundWorker<T, V>(){

            @Override
            protected T doInBackground() throws Exception {
                return AbstractTask.this.processInBackground(this.context);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    Object result = this.get();
                    AbstractTask.this.onTaskSuccess(result);
                    this.owner.onTaskSuccess();
                }
                catch (InterruptedException e) {
                    AbstractTask.this.onTaskFailure(e);
                    this.owner.onTaskFailure(e);
                }
                catch (ExecutionException e) {
                    AbstractTask.this.onTaskFailure(e.getCause());
                    this.owner.onTaskFailure(e.getCause());
                }
                finally {
                    AbstractTask.this.onFinally();
                }
            }

            @Override
            protected void process(List<V> results) {
                AbstractTask.this.processIntermediateResults(results);
            }
        };
        this.support = this.worker.getPropertyChangeSupport();
    }

    public M getModel() {
        return this.model;
    }

    @Override
    public void execute(IController owner) {
        if (this.submitted.compareAndSet(false, true)) {
            this.controller = owner;
            this.worker.setOwner(this.controller);
            this.worker.execute();
        }
    }

    public abstract T processInBackground(Context var1) throws Exception;

    public abstract void onTaskSuccess(T var1);

    public abstract void onTaskFailure(Throwable var1);

    public abstract void onFinally();

    protected abstract void processIntermediateResults(List<V> var1);

    @Override
    public boolean isSubmitted() {
        return this.submitted.get();
    }

    @Override
    public boolean isDone() {
        return this.worker.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.worker.isCancelled();
    }

    @Override
    public void cancel(boolean mayInterruptIfRunning) {
        this.worker.cancel(mayInterruptIfRunning);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.support.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.worker.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.worker.removePropertyChangeListener(listener);
    }

    @SafeVarargs
    protected final void publish(V ... chunks) {
        this.worker.publishIntermediateResults(chunks);
    }

    protected final void setProgress(int progress) {
        this.worker.setTaskProgress(progress);
    }

    protected final IController getController() {
        return this.controller;
    }
}

