/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.CertsDescription;
import com.intel.stl.api.FMException;
import com.intel.stl.api.FMKeyStoreException;
import com.intel.stl.api.FMTrustStoreException;
import com.intel.stl.api.IConnectionAssistant;
import com.intel.stl.api.ISubnetEventListener;
import com.intel.stl.api.SSLStoreCredentialsDeniedException;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.SubnetContext;
import com.intel.stl.api.SubnetEvent;
import com.intel.stl.api.configuration.ConfigurationException;
import com.intel.stl.api.configuration.IConfigurationApi;
import com.intel.stl.api.configuration.UserNotFoundException;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.logs.ILogApi;
import com.intel.stl.api.management.IManagementApi;
import com.intel.stl.api.notice.INoticeApi;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SubnetConnectionException;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.alert.NoticeEventListener;
import com.intel.stl.ui.alert.NoticeNotifier;
import com.intel.stl.ui.alert.NotifierFactory;
import com.intel.stl.ui.alert.NotifierType;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.CertsLoginController;
import com.intel.stl.ui.main.IFabricController;
import com.intel.stl.ui.model.UserPreference;
import com.intel.stl.ui.publisher.EventCalculator;
import com.intel.stl.ui.publisher.TaskScheduler;
import com.intel.stl.ui.publisher.UserSettingsProcessor;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context
implements ISubnetEventListener,
IConnectionAssistant {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    public static final long TIME_OUT = 30000L;
    private TaskScheduler scheduler;
    private EventCalculator evtCal;
    private UserSettingsProcessor userSettingsProcessor;
    private List<Throwable> errors;
    private final SubnetContext subnetContext;
    private final IFabricController controller;
    private final String userName;
    private UserPreference userPreference;
    private final Component owner;
    private final NoticeEventListener noticeListener;
    private NoticeNotifier emailNotifier;

    public Context(SubnetContext subnetContext, IFabricController controller, String userName) {
        this.subnetContext = subnetContext;
        this.userName = userName;
        this.controller = controller;
        this.owner = controller.getViewFrame();
        this.noticeListener = new NoticeEventListener(controller.getEventBus());
        this.subnetContext.addSubnetEventListener(this);
        this.subnetContext.getSubnetDescription().setConnectionAssistant(this);
    }

    public Component getOwner() {
        return this.owner;
    }

    public IFabricController getController() {
        return this.controller;
    }

    public EventCalculator getEvtCal() {
        return this.evtCal;
    }

    public void initialize() throws SubnetConnectionException {
        int sweepInterval;
        this.subnetContext.initialize();
        this.getNoticeApi().addEventListener(this.noticeListener);
        this.refreshUserSettings();
        UserSettings userSettings = this.getUserSettings();
        this.userPreference = new UserPreference(userSettings);
        EnumMap<NodeType, Integer> nodes = null;
        try {
            nodes = this.subnetContext.getSubnetApi().getNodesTypeDist(false, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.evtCal = new EventCalculator(nodes, this.userPreference);
        this.subnetContext.getNoticeApi().addEventListener(this.evtCal);
        this.userSettingsProcessor = new UserSettingsProcessor(userSettings, this);
        PMConfigBean pmConf = this.getPerformanceApi().getPMConfig();
        int refreshRate = this.userPreference.getRefreshRateInSeconds();
        this.scheduler = pmConf != null ? (refreshRate > (sweepInterval = pmConf.getSweepInterval()) ? new TaskScheduler(this, refreshRate) : new TaskScheduler(this, sweepInterval)) : new TaskScheduler(this, refreshRate);
        this.emailNotifier = NotifierFactory.createNotifier(NotifierType.MAIL, this);
        this.subnetContext.getNoticeApi().addEventListener(this.emailNotifier);
    }

    public NoticeNotifier getEmailNotifier() {
        return this.emailNotifier;
    }

    public IConfigurationApi getConfigurationApi() {
        return this.subnetContext.getConfigurationApi();
    }

    public ISubnetApi getSubnetApi() {
        return this.subnetContext.getSubnetApi();
    }

    public IPerformanceApi getPerformanceApi() {
        return this.subnetContext.getPerformanceApi();
    }

    public INoticeApi getNoticeApi() {
        return this.subnetContext.getNoticeApi();
    }

    public ILogApi getLogApi() {
        return this.subnetContext.getLogApi();
    }

    public IManagementApi getManagementApi() {
        return this.subnetContext.getManagementApi();
    }

    public UserSettings getUserSettings() {
        UserSettings userSettings = null;
        try {
            userSettings = this.subnetContext.getUserSettings(this.userName);
        }
        catch (UserNotFoundException e) {
            e.printStackTrace();
        }
        return userSettings;
    }

    public void refreshUserSettings() {
        try {
            this.subnetContext.refreshUserSettings(this.userName);
            if (this.userSettingsProcessor != null) {
                UserSettings userSettings = this.getUserSettings();
                this.userSettingsProcessor.process(userSettings);
            }
        }
        catch (UserNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setRandom(boolean random) {
        this.subnetContext.setRandom(random);
    }

    public void addSubnetEventListener(ISubnetEventListener listener) {
        this.subnetContext.addSubnetEventListener(listener);
    }

    public void removeSubnetEventListener(ISubnetEventListener listener) {
        this.subnetContext.removeSubnetEventListener(listener);
    }

    public void addFailoverProgressListener(PropertyChangeListener listener) {
        this.subnetContext.addFailoverProgressListener(listener);
    }

    public void removeFailoverProgressListener(PropertyChangeListener listener) {
        this.subnetContext.removeFailoverProgressListener(listener);
    }

    public void setDeleted(boolean deleted) {
        this.subnetContext.setDeleted(deleted);
    }

    public TaskScheduler getTaskScheduler() {
        return this.scheduler;
    }

    public SubnetDescription getSubnetDescription() {
        return this.subnetContext.getSubnetDescription();
    }

    public void close() {
        final SubnetDescription.Status status = this.subnetContext.isValid() ? SubnetDescription.Status.VALID : SubnetDescription.Status.INVALID;
        final IConfigurationApi confApi = this.subnetContext.getConfigurationApi();
        SubnetDescription subnet = this.subnetContext.getSubnetDescription();
        final long subnetId = subnet.getSubnetId();
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                try {
                    SubnetDescription subnetDesc = confApi.getSubnet(subnetId);
                    subnetDesc.setLastStatus(status);
                    SubnetDescription currentSubnet = Context.this.subnetContext.getSubnetDescription();
                    subnetDesc.getCurrentFE().setSshUserName(currentSubnet.getCurrentFE().getSshUserName());
                    subnetDesc.getCurrentFE().setSshPortNum(currentSubnet.getCurrentFE().getSshPortNum());
                    confApi.updateSubnet(subnetDesc);
                }
                catch (SubnetDataNotFoundException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }
        });
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
            if (this.noticeListener != null) {
                this.noticeListener.shutdown();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.subnetContext.cleanup();
        }
    }

    public boolean isValid() {
        return this.subnetContext.isValid();
    }

    @Override
    public void onFailoverCompleted(SubnetEvent event) {
    }

    @Override
    public void onFailoverFailed(SubnetEvent event) {
        log.debug("Context is cleaning up after failover failed");
        this.cleanup();
    }

    @Override
    public void onSubnetManagerConnectionLost(SubnetEvent event) {
        log.debug("Stopping the task scheduler");
        try {
            this.scheduler.suspendServiceDuringFailover();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cancelFailover() {
        this.subnetContext.cancelFailover();
    }

    @Override
    public void onSubnetManagerConnected(SubnetEvent arg0) {
    }

    @Override
    public CertsDescription getSSLStoreCredentials(HostInfo hostInfo) throws SSLStoreCredentialsDeniedException {
        CertsDescription certs = null;
        CertsLoginController loginCtr = this.controller.getCertsLoginController();
        if (this.errors != null) {
            for (Throwable error : this.errors) {
                Throwable cause;
                System.out.println("error=" + error);
                if (error instanceof FMKeyStoreException) {
                    cause = this.getPasswordException(error);
                    if (cause != null) {
                        loginCtr.setKeyStorePwdError(StringUtils.getErrorMessage(cause));
                        continue;
                    }
                    loginCtr.setKeyStoreLocError(StringUtils.getErrorMessage(error));
                    continue;
                }
                if (error instanceof FMTrustStoreException) {
                    cause = this.getPasswordException(error);
                    if (cause != null) {
                        loginCtr.setTrustStorePwdError(StringUtils.getErrorMessage(cause));
                        continue;
                    }
                    loginCtr.setTrustStoreLocError(StringUtils.getErrorMessage(error));
                    continue;
                }
                log.warn("Unsupported error", error);
            }
        } else {
            this.errors = new ArrayList<Throwable>();
        }
        certs = loginCtr.getSSLCredentials(hostInfo);
        if (this.errors != null) {
            this.errors.clear();
        }
        return certs;
    }

    @Override
    public void onSSLStoreError(FMException fmException) {
        this.errors.add(fmException);
    }

    public void reset() {
        this.subnetContext.reset();
    }

    private Throwable getPasswordException(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        if (e instanceof UnrecoverableKeyException && e.getMessage().contains("Password")) {
            return e;
        }
        return null;
    }
}

