/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.AppContext;
import com.intel.stl.api.FMGuiPlugin;
import com.intel.stl.api.ICertsAssistant;
import com.intel.stl.api.StringUtils;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.DialogFactory;
import com.intel.stl.ui.main.CertsAssistant;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.ISubnetManager;
import com.intel.stl.ui.main.SubnetManager;
import com.intel.stl.ui.main.view.CertsPanel;
import com.intel.stl.ui.main.view.SplashScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricPlugin
extends FMGuiPlugin {
    private static final Logger log = LoggerFactory.getLogger(FMGuiPlugin.class);
    private SplashScreen splashScreen;
    private ICertsAssistant certsAssistant;
    private ISubnetManager subnetMgr;
    private final List<Throwable> errors = new ArrayList<Throwable>();

    @Override
    public void init(AppContext appContext) {
        CertsPanel certsPanel = new CertsPanel();
        this.certsAssistant = new CertsAssistant(certsPanel, appContext.getConfigurationApi());
        appContext.registerCertsAssistant(this.certsAssistant);
        super.init(appContext);
        try {
            System.setProperty("awt.useSystemAAFontSettings", "on");
            System.setProperty("swing.aatext", "true");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (System.getProperty("os.name").equals("Linux")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            UIManager.put("SplitPaneDivider.draggingColor", UIConstants.INTEL_LIGHT_GRAY);
            Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
            System.setProperty("sun.awt.exception.handler", ExceptionHandler.class.getName());
            HelpAction.DYNAMIC_SIZE = true;
        }
        catch (Exception e) {
            this.errors.add(e);
            e.printStackTrace();
        }
        this.splashScreen = new SplashScreen();
        this.splashScreen.showScreen();
    }

    @Override
    public void invokeMain(boolean firstRun) {
        this.splashScreen.setProgress("Initializing UI", 99);
        try {
            this.subnetMgr = this.createSubnetManager();
            this.subnetMgr.init(firstRun);
        }
        catch (Throwable e) {
            this.errors.add(e);
            e.printStackTrace();
        }
        if (!this.errors.isEmpty()) {
            StringBuffer msg = new StringBuffer();
            for (Throwable e : this.errors) {
                msg.append(StringUtils.getErrorMessage(e));
            }
            throw new RuntimeException(msg.toString());
        }
        this.subnetMgr.startSubnets(this.splashScreen);
    }

    protected ISubnetManager createSubnetManager() {
        AppContext appContext = this.getAppContext();
        return new SubnetManager(appContext, this.certsAssistant);
    }

    @Override
    public void setProgress(int progress) {
        this.splashScreen.setProgress(progress);
    }

    @Override
    public void setProgress(String message) {
        this.splashScreen.setProgress(message);
    }

    @Override
    public void setProgress(String message, int progress) {
        this.splashScreen.setProgress(message, progress);
    }

    @Override
    public void showErrors(List<Throwable> errors) {
        for (Throwable e : errors) {
            e.printStackTrace();
        }
        if (!this.splashScreen.isClosed()) {
            this.splashScreen.toBack();
        }
        DialogFactory.showModalErrorDialog(null, errors);
    }

    @Override
    public void shutdown() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (!FabricPlugin.this.splashScreen.isClosed()) {
                    FabricPlugin.this.splashScreen.close();
                }
                FabricPlugin.this.splashScreen = new SplashScreen();
                FabricPlugin.this.splashScreen.setShutdownImage();
                FabricPlugin.this.splashScreen.showScreen();
                if (FabricPlugin.this.subnetMgr != null) {
                    try {
                        FabricPlugin.this.subnetMgr.cleanup();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error(e.getMessage() + " @ " + t, e);
            if (FMGuiPlugin.IS_DEV) {
                FabricPlugin.this.showErrors(Arrays.asList(e));
            }
        }
    }
}

