/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.PinnableCardController;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.view.HealthHistoryView;
import com.intel.stl.ui.model.TimedScore;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import net.engio.mbassy.bus.MBassador;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.util.Log;

public class HealthHistoryCard
extends PinnableCardController<ICardListener, HealthHistoryView> {
    private final TimePeriodValues dataset = new TimePeriodValues(STLConstants.K0105_HEALTH_HISTORY.getValue());
    private final TimePeriodValuesCollection timeseriescollection = new TimePeriodValuesCollection(this.dataset);
    private Date lastTime = null;
    private final int maxHistoryLength = 21600000;
    private final double INIT_SCORE = 100.0;
    private double lastScore = 100.0;

    public HealthHistoryCard(HealthHistoryView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.timeseriescollection.setXPosition(TimePeriodAnchor.START);
        view.setDataset((IntervalXYDataset)this.timeseriescollection);
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getHealthTrend();
    }

    public TimePeriodValues getDataset() {
        return this.dataset;
    }

    @Override
    public void clear() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                HealthHistoryCard.this.lastTime = null;
                if (HealthHistoryCard.this.dataset.getItemCount() > 0) {
                    HealthHistoryCard.this.dataset.delete(0, HealthHistoryCard.this.dataset.getItemCount() - 1);
                }
                ((HealthHistoryView)HealthHistoryCard.this.view).setCurrentScore(STLConstants.K0039_NOT_AVAILABLE.getValue(), UIConstants.INTEL_DARK_GRAY, "");
                if (HealthHistoryCard.this.pinView != null) {
                    ((HealthHistoryView)HealthHistoryCard.this.pinView).setCurrentScore(STLConstants.K0039_NOT_AVAILABLE.getValue(), UIConstants.INTEL_DARK_GRAY, "");
                }
            }
        });
    }

    public void updateHealthScore(final double score, final Date time, final String tip) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                HealthHistoryCard.this.lastScore = score;
                TimedScore tScore = new TimedScore(time.getTime(), score, tip);
                ((HealthHistoryView)HealthHistoryCard.this.view).setCurrentScore(tScore.getScoreString(), tScore.getColor(), tip);
                if (HealthHistoryCard.this.lastTime == null) {
                    Date fakedLastTime = new Date(time.getTime() - 1000L);
                    HealthHistoryCard.this.dataset.add((TimePeriod)new SimpleTimePeriod(fakedLastTime, time), (Number)score);
                    HealthHistoryCard.this.lastTime = time;
                }
                if (HealthHistoryCard.this.lastTime.after(time)) {
                    Log.warn((Object)("time mismatch happend lastTime=" + HealthHistoryCard.this.lastTime + " current time=" + time));
                    HealthHistoryCard.this.dataset.add((TimePeriod)new SimpleTimePeriod(HealthHistoryCard.this.lastTime, HealthHistoryCard.this.lastTime), (Number)score);
                } else {
                    HealthHistoryCard.this.dataset.add((TimePeriod)new SimpleTimePeriod(HealthHistoryCard.this.lastTime, time), (Number)score);
                    HealthHistoryCard.this.lastTime = time;
                }
                long startTime = HealthHistoryCard.this.dataset.getTimePeriod(0).getStart().getTime();
                long endTime = HealthHistoryCard.this.dataset.getTimePeriod(HealthHistoryCard.this.dataset.getItemCount() - 1).getEnd().getTime();
                while (endTime - startTime > 21600000L) {
                    HealthHistoryCard.this.dataset.delete(0, 0);
                    startTime = HealthHistoryCard.this.dataset.getTimePeriod(0).getStart().getTime();
                }
                String start = DateFormat.getInstance().format(new Date(startTime));
                String end = DateFormat.getInstance().format(new Date(endTime));
                ((HealthHistoryView)HealthHistoryCard.this.view).setTimeDuration(start, end);
                if (HealthHistoryCard.this.pinView != null) {
                    ((HealthHistoryView)HealthHistoryCard.this.pinView).setTimeDuration(start, end);
                    ((HealthHistoryView)HealthHistoryCard.this.pinView).setCurrentScore(tScore.getScoreString(), tScore.getColor(), tScore.getTip());
                }
            }
        });
    }

    @Override
    public ICardListener getCardListener() {
        return this;
    }

    public String toString() {
        return "HealthHistoryCard ";
    }

    @Override
    protected void generateArgument(Properties arg) {
    }

    @Override
    protected HealthHistoryView createPinView() {
        HealthHistoryView pinView = new HealthHistoryView(UIConstants.H2_FONT.deriveFont(1));
        pinView.setCardListener(this.getCardListener());
        return pinView;
    }

    @Override
    protected void initPinView() {
        TimedScore tScore = new TimedScore(System.currentTimeMillis(), this.lastScore);
        ((HealthHistoryView)this.pinView).setCurrentScore(tScore.getScoreString(), tScore.getColor(), "");
        ((HealthHistoryView)this.pinView).setDataset((IntervalXYDataset)this.timeseriescollection);
    }

    @Override
    public PinDescription.PinID getPinID() {
        return PinDescription.PinID.HEALTH;
    }
}

