/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.view.NodeStatusPanel;
import com.intel.stl.ui.model.ChartStyle;
import com.intel.stl.ui.model.StateLongTypeViz;
import java.util.EnumMap;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class NodeStatusController {
    private final NodeStatusPanel view;
    private int lastTotal;
    private final DefaultPieDataset dataset;
    private EnumMap<NoticeSeverity, Integer> lastStates;

    public NodeStatusController(NodeStatusPanel view) {
        this.view = view;
        this.dataset = new DefaultPieDataset();
        StateLongTypeViz[] states = StateLongTypeViz.values();
        for (int i = 0; i < states.length; ++i) {
            this.dataset.setValue((Comparable)((Object)states[i].getName()), 0.0);
        }
        view.setDataset((PieDataset)this.dataset, StateLongTypeViz.colors);
    }

    public int getLastTotal() {
        return this.lastTotal;
    }

    public EnumMap<NoticeSeverity, Integer> getLastStates() {
        return this.lastStates;
    }

    public void updateStates(EnumMap<NoticeSeverity, Integer> states, final int total) {
        this.lastStates = states;
        this.lastTotal = total;
        if (this.lastStates == null) {
            this.view.clear();
            return;
        }
        final int[] counts = StateLongTypeViz.getDistributionValues(states, total);
        int countsLen = 0;
        if (counts != null) {
            countsLen = counts.length;
        }
        final double[] values = new double[countsLen];
        final String[] labels = new String[countsLen];
        final String[] tooltips = new String[countsLen];
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < counts.length; ++i) {
                    NodeStatusController.this.dataset.setValue((Comparable)((Object)StateLongTypeViz.values()[i].getName()), (double)counts[i]);
                    if (total > 0) {
                        values[i] = (double)counts[i] / (double)total;
                        labels[i] = UIConstants.INTEGER.format(counts[i]) + " (" + UIConstants.PERCENTAGE.format(values[i]) + ") ";
                        tooltips[i] = UILabels.STL10202_NODE_STATES.getDescription(UIConstants.INTEGER.format(counts[i]), UIConstants.PERCENTAGE.format(values[i]), StateLongTypeViz.names[i]);
                        continue;
                    }
                    labels[i] = STLConstants.K0039_NOT_AVAILABLE.getValue();
                    tooltips[i] = null;
                }
                NodeStatusController.this.view.setStates(values, labels, tooltips);
            }
        });
    }

    public void setStyle(ChartStyle style) {
        this.view.setStyle(style);
        this.updateStates(this.lastStates, this.lastTotal);
    }

    public void clear() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                NodeStatusController.this.dataset.clear();
                NodeStatusController.this.view.clear();
            }
        });
    }
}

