/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.ui.common.IPinCard;
import com.intel.stl.ui.common.IPinProvider;
import com.intel.stl.ui.common.PinArgument;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.DecoratedPinCardView;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.IFabricController;
import com.intel.stl.ui.main.view.PinBoardView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinBoardController {
    private static final Logger log = LoggerFactory.getLogger(PinBoardController.class);
    private static final int DEFAULT_SIZE = 8;
    private static boolean DUMP_PERSISTENCE = true;
    private final IFabricController parent;
    private final PinBoardView view;
    private final Map<PinDescription.PinID, IPinProvider> pinProviders = new HashMap<PinDescription.PinID, IPinProvider>();
    private final List<PinItem> pinItems = new ArrayList<PinItem>();
    private final BlockingQueue<PinDescription> toAdd;
    private final int size;

    public PinBoardController(PinBoardView view, IFabricController parent) {
        this(view, parent, 8);
    }

    public PinBoardController(PinBoardView view, IFabricController parent, int size) {
        this.view = view;
        this.parent = parent;
        this.size = size;
        this.toAdd = new ArrayBlockingQueue<PinDescription>(size);
    }

    public void init() {
        if (this.parent.getCurrentContext() != null) {
            if (this.pinItems.isEmpty()) {
                this.restore();
            } else {
                ArrayList<PinDescription> pins = new ArrayList<PinDescription>();
                for (PinItem pi : this.pinItems) {
                    pins.add(pi.getCard().getDescription());
                }
                this.restorePins(pins);
            }
        }
    }

    public PinBoardView getView() {
        return this.view;
    }

    public synchronized void registerPinProvider(PinDescription.PinID id, IPinProvider provider) {
        if (this.pinProviders.containsKey((Object)id)) {
            throw new IllegalArgumentException((Object)((Object)id) + " Provider already exist!");
        }
        this.pinProviders.put(id, provider);
    }

    public synchronized void deregisterPinProvider(PinDescription.PinID id) {
        this.pinProviders.remove((Object)id);
    }

    public void restorePins(List<PinDescription> pins) {
        this.clear();
        for (PinDescription pin : pins) {
            try {
                this.addPin(pin);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Cannot restore pin for " + pin, (Throwable)e);
            }
        }
    }

    public void addPin(PinDescription pin) {
        if (this.pinItems.size() + this.toAdd.size() >= this.size) {
            Util.showErrorMessage(this.parent.getViewFrame(), UILabels.STL10115_MAX_PINS.getDescription(Integer.toString(this.size)));
            return;
        }
        this.toAdd.add(pin);
        if (this.toAdd.size() == 1) {
            this.addPinsInBackground();
        }
    }

    protected void addPinsInBackground() {
        Runnable work = new Runnable(){

            @Override
            public void run() {
                PinDescription pin = null;
                while ((pin = (PinDescription)PinBoardController.this.toAdd.poll()) != null) {
                    IPinProvider provider = (IPinProvider)PinBoardController.this.pinProviders.get((Object)pin.getID());
                    if (provider == null) {
                        log.error("Cannot find provider for " + (Object)((Object)pin.getID()));
                        continue;
                    }
                    IPinCard card = provider.createPin(pin);
                    final DecoratedPinCardView cardView = PinBoardController.this.decoratePinView(card.getView(), pin, card);
                    PinBoardController.this.pinItems.add(new PinItem(card, cardView));
                    Util.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            if (PinBoardController.this.pinItems.size() > 1) {
                                cardView.enableUpButton(true);
                                ((PinItem)PinBoardController.this.pinItems.get(PinBoardController.this.pinItems.size() - 2)).getView().enableDownButton(true);
                            }
                            PinBoardController.this.view.appendPinCardView(cardView);
                        }
                    });
                }
            }
        };
        Thread addingThread = new Thread(null, work, "PinBoard");
        addingThread.start();
    }

    protected DecoratedPinCardView decoratePinView(Component comp, PinDescription pin, final IPinCard card) {
        String title = pin.getTitle();
        DecoratedPinCardView view = new DecoratedPinCardView(comp, title, pin);
        view.setUpAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PinBoardController.this.goUp(card);
            }
        });
        view.setDownAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PinBoardController.this.goDown(card);
            }
        });
        view.setCloseAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PinBoardController.this.unpin(card);
            }
        });
        return view;
    }

    protected void goUp(IPinCard card) {
        int index = this.indexOf(card);
        if (index <= 0) {
            throw new IllegalArgumentException("Cannot go up because this Pin's index is " + index);
        }
        PinItem item = this.pinItems.remove(index);
        this.pinItems.add(index - 1, item);
        this.resetView();
    }

    protected void goDown(IPinCard card) {
        int index = this.indexOf(card);
        if (index >= this.pinItems.size() - 1) {
            throw new IllegalArgumentException("Cannot go down because there is total " + this.pinItems.size() + " pins, and this Pin's index is " + index);
        }
        PinItem item = this.pinItems.remove(index);
        this.pinItems.add(index + 1, item);
        this.resetView();
    }

    protected void unpin(final IPinCard card) {
        Context context;
        int index = this.indexOf(card);
        PinItem item = this.pinItems.remove(index);
        this.view.removePinCardView(item.getView());
        if (!this.pinItems.isEmpty()) {
            item = this.pinItems.get(0);
            item.getView().enableUpButton(false);
            item = this.pinItems.get(this.pinItems.size() - 1);
            item.getView().enableDownButton(false);
        }
        if ((context = this.parent.getCurrentContext()) == null) {
            throw new RuntimeException("No context on FabricController " + this.parent);
        }
        context.getTaskScheduler().submitToBackground(new Runnable(){

            @Override
            public void run() {
                card.unpin();
            }
        });
    }

    protected void resetView() {
        DecoratedPinCardView[] cardViews = new DecoratedPinCardView[this.pinItems.size()];
        for (int i = 0; i < this.pinItems.size(); ++i) {
            PinItem item = this.pinItems.get(i);
            cardViews[i] = item.getView();
            cardViews[i].enableUpButton(i > 0);
            cardViews[i].enableDownButton(i < this.pinItems.size() - 1);
        }
        this.view.setPinCardViews(cardViews);
    }

    protected int indexOf(IPinCard card) {
        for (int i = 0; i < this.pinItems.size(); ++i) {
            PinItem item = this.pinItems.get(i);
            if (item.getCard() != card) continue;
            return i;
        }
        throw new IllegalArgumentException("Cannot find the PinCard " + card);
    }

    public boolean contains(PinDescription pin) {
        return this.contains(pin.getTitle(), pin.getArgument());
    }

    public boolean contains(String title, PinArgument arg) {
        for (PinItem item : this.pinItems) {
            PinDescription itemPin = item.getCard().getDescription();
            if (!title.equals(itemPin.getTitle()) || !arg.equals(itemPin.getArgument())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            this.save();
        }
        finally {
            this.clear();
            this.pinProviders.clear();
        }
    }

    protected void clear() {
        this.view.clear();
        for (PinItem pinItem : this.pinItems) {
            pinItem.getCard().unpin();
        }
        this.pinItems.clear();
    }

    protected void save() {
        Context context = this.parent.getCurrentContext();
        if (context != null) {
            UserSettings settings = context.getUserSettings();
            if (settings != null) {
                Properties pinProps = this.getPinBoardProperties();
                if (DUMP_PERSISTENCE) {
                    System.out.println("=========== to save ==============");
                    System.out.println(pinProps);
                }
                settings.getPreferences().put("PinBoard", pinProps);
            }
        } else {
            log.warn("No context on FabricController " + this.parent);
        }
    }

    protected void restore() {
        Context context = this.parent.getCurrentContext();
        if (context != null) {
            UserSettings settings = context.getUserSettings();
            if (settings != null) {
                Properties pinProps = settings.getPreferences().get("PinBoard");
                if (DUMP_PERSISTENCE) {
                    System.out.println("=========== to restore ==============");
                    System.out.println(pinProps);
                }
                if (pinProps != null) {
                    List<PinDescription> pinDescs = this.restorePinDescs(pinProps);
                    for (PinDescription pinDesc : pinDescs) {
                        this.addPin(pinDesc);
                    }
                }
            }
        } else {
            log.warn("No context on FabricController " + this.parent);
        }
    }

    protected Properties getPinBoardProperties() {
        Properties res = new Properties();
        for (int i = 0; i < this.pinItems.size(); ++i) {
            PinItem pinItem = this.pinItems.get(i);
            PinDescription pinDesc = pinItem.getCard().getDescription();
            pinDesc.setHeight(pinItem.getView().getComponentHeight());
            res.put(Integer.toString(i), pinDesc.persistent());
        }
        return res;
    }

    protected List<PinDescription> restorePinDescs(Properties props) {
        ArrayList<PinDescription> res = new ArrayList<PinDescription>();
        int i = 0;
        String tmp = null;
        while ((tmp = props.getProperty(Integer.toString(i++))) != null) {
            PinDescription pinDesc = PinDescription.restore(tmp);
            res.add(pinDesc);
        }
        return res;
    }

    protected class PinItem {
        private final IPinCard card;
        private final DecoratedPinCardView view;

        public PinItem(IPinCard card, DecoratedPinCardView view) {
            this.card = card;
            this.view = view;
        }

        public IPinCard getCard() {
            return this.card;
        }

        public DecoratedPinCardView getView() {
            return this.view;
        }
    }
}

