/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.view.StaDetailsPanel;
import com.intel.stl.ui.model.NodeTypeViz;
import com.intel.stl.ui.model.StateShortTypeViz;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.Timer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;

public class StaDetailsController {
    private final NodeTypeViz[] nodeTypes;
    private final String name;
    private final DefaultCategoryDataset failedDataset;
    private final DefaultCategoryDataset skippedDataset;
    private final DefaultPieDataset typeDataset;
    private final StaDetailsPanel view;
    private Timer viewClearTimer;

    public StaDetailsController(String name, StaDetailsPanel view) {
        this.view = view;
        this.name = name;
        view.setNameLabel(name);
        this.failedDataset = new DefaultCategoryDataset();
        this.failedDataset.addValue(0.0, (Comparable)((Object)name), (Comparable)((Object)StateShortTypeViz.NORESP.name()));
        view.setFailedDataset(this.failedDataset);
        this.skippedDataset = new DefaultCategoryDataset();
        this.skippedDataset.addValue(0.0, (Comparable)((Object)name), (Comparable)((Object)StateShortTypeViz.SKIPPED.name()));
        view.setSkipedDataset(this.skippedDataset);
        this.typeDataset = new DefaultPieDataset();
        this.nodeTypes = view.getTypes();
        Color[] colors = new Color[this.nodeTypes.length];
        for (int i = 0; i < colors.length; ++i) {
            this.typeDataset.setValue((Comparable)((Object)this.nodeTypes[i].getName()), 0.0);
            colors[i] = this.nodeTypes[i].getColor();
        }
        view.setTypeDataset(this.typeDataset, colors);
    }

    public StaDetailsPanel getView() {
        return this.view;
    }

    public String getName() {
        return this.name;
    }

    public DefaultCategoryDataset getFailedDataset() {
        return this.failedDataset;
    }

    public DefaultCategoryDataset getSkippedDataset() {
        return this.skippedDataset;
    }

    public DefaultPieDataset getTypeDataset() {
        return this.typeDataset;
    }

    public void setStates(final long total, final long failed, final long skipped) {
        this.clearTimer();
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                StaDetailsController.this.failedDataset.setValue((double)failed / (double)total, (Comparable)((Object)StaDetailsController.this.name), (Comparable)((Object)StateShortTypeViz.NORESP.name()));
                StaDetailsController.this.skippedDataset.setValue((double)skipped / (double)total, (Comparable)((Object)StaDetailsController.this.name), (Comparable)((Object)StateShortTypeViz.SKIPPED.name()));
                String failedStr = UIConstants.INTEGER.format(failed);
                String skippedStr = UIConstants.INTEGER.format(skipped);
                StaDetailsController.this.view.setFailed(failedStr);
                StaDetailsController.this.view.setSkipped(skippedStr);
            }
        });
    }

    public void setTypes(int total, EnumMap<NodeType, Integer> types) {
        EnumMap<NodeType, Long> wrapper = new EnumMap<NodeType, Long>(NodeType.class);
        for (NodeType nodeType : types.keySet()) {
            wrapper.put(nodeType, (long)types.get((Object)nodeType));
        }
        this.setTypes((long)total, wrapper);
    }

    public void setTypes(final long total, EnumMap<NodeType, Long> types) {
        this.clearTimer();
        final long[] counts = NodeTypeViz.getDistributionValues(types);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                String totalNumber = UIConstants.INTEGER.format(total);
                StaDetailsController.this.view.setTotalNumber(totalNumber);
                for (NodeTypeViz nodeType : StaDetailsController.this.nodeTypes) {
                    long count = counts[nodeType.ordinal()];
                    StaDetailsController.this.typeDataset.setValue((Comparable)((Object)nodeType.getName()), (double)count);
                    String number = UIConstants.INTEGER.format(count);
                    String label = StaDetailsController.this.getTypeString(count, nodeType);
                    StaDetailsController.this.view.setTypeInfo(nodeType, number, label);
                }
            }
        });
    }

    protected String getTypeString(long count, NodeTypeViz nodeType) {
        String label = count == 1L ? nodeType.getName() : nodeType.getPluralName();
        return label;
    }

    protected void clearTimer() {
        if (this.viewClearTimer != null) {
            if (this.viewClearTimer.isRunning()) {
                this.viewClearTimer.stop();
            }
            this.viewClearTimer = null;
        }
    }

    public void clear() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                StaDetailsController.this.failedDataset.clear();
                StaDetailsController.this.skippedDataset.clear();
                StaDetailsController.this.typeDataset.clear();
            }
        });
        if (this.viewClearTimer == null) {
            this.viewClearTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (StaDetailsController.this.viewClearTimer != null) {
                        StaDetailsController.this.view.clear();
                    }
                }
            });
            this.viewClearTimer.setRepeats(false);
        }
        this.viewClearTimer.restart();
    }
}

