/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.performance.SMInfoDataBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.BaseCardController;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.StaDetailsController;
import com.intel.stl.ui.main.view.StatisticsView;
import com.intel.stl.ui.model.GroupStatistics;
import com.intel.stl.ui.model.NodeTypeViz;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Timer;
import net.engio.mbassy.bus.MBassador;

public class StatisticsCard
extends BaseCardController<ICardListener, StatisticsView> {
    private final StaDetailsController nodesController;
    private final StaDetailsController portsController;
    private Timer viewClearTimer;

    public StatisticsCard(StatisticsView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.nodesController = new StaDetailsController(STLConstants.K0014_ACTIVE_NODES.getValue(), view.getNodesPanel());
        this.portsController = new StaDetailsController(STLConstants.K0024_ACTIVE_PORTS.getValue(), view.getPortsPanel()){

            @Override
            protected String getTypeString(long count, NodeTypeViz nodeType) {
                if (count == 1L) {
                    if (nodeType == NodeTypeViz.SWITCH) {
                        return STLConstants.K0135_SW_PORT.getValue();
                    }
                    if (nodeType == NodeTypeViz.HFI) {
                        return STLConstants.K0137_HFI_PORT.getValue();
                    }
                } else {
                    if (nodeType == NodeTypeViz.SWITCH) {
                        return STLConstants.K0136_SW_PORTS.getValue();
                    }
                    if (nodeType == NodeTypeViz.HFI) {
                        return STLConstants.K0138_HFI_PORTS.getValue();
                    }
                }
                return super.getTypeString(count, nodeType);
            }
        };
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getSubnetStatisticsName();
    }

    public StaDetailsController getNodesController() {
        return this.nodesController;
    }

    public StaDetailsController getPortsController() {
        return this.portsController;
    }

    public void updateStatistics(final GroupStatistics sta) {
        if (this.viewClearTimer != null) {
            if (this.viewClearTimer.isRunning()) {
                this.viewClearTimer.stop();
            }
            this.viewClearTimer = null;
        }
        int totalNodes = sta.getNumNodes();
        this.nodesController.setStates(totalNodes, sta.getNumNoRespNodes(), sta.getNumSkippedNodes());
        this.nodesController.setTypes(totalNodes, sta.getNodeTypesDist());
        long totalPorts = sta.getNumActivePorts();
        this.portsController.setStates(totalPorts, sta.getNumNoRespPorts(), sta.getNumSkippedPorts());
        this.portsController.setTypes(totalPorts, sta.getPortTypesDist());
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                ((StatisticsView)StatisticsCard.this.view).setTitle(StatisticsCard.this.getTitle(sta));
                ((StatisticsView)StatisticsCard.this.view).setDuration(sta.getMsmUptimeInSeconds(), TimeUnit.SECONDS);
                long numLinks = sta.getNumLinks();
                long numHostLinks = sta.getNodeTypesDist().get((Object)NodeType.HFI).intValue();
                long numSwitchLinks = 0L;
                Integer switches = sta.getNodeTypesDist().get((Object)NodeType.SWITCH);
                if (switches != null && switches > 0) {
                    numSwitchLinks = numLinks - numHostLinks;
                }
                ((StatisticsView)StatisticsCard.this.view).setNumSwitchLinks(UIConstants.INTEGER.format(numSwitchLinks));
                ((StatisticsView)StatisticsCard.this.view).setNumHostLinks(UIConstants.INTEGER.format(numHostLinks));
                ((StatisticsView)StatisticsCard.this.view).setOtherPorts(UIConstants.INTEGER.format(sta.getOtherPorts()));
                List<SMInfoDataBean> sms = sta.getSMInfo();
                if (sta.getNumSMs() > 0) {
                    ((StatisticsView)StatisticsCard.this.view).setMsmName(sms.get(0).getSmNodeDesc(), StatisticsCard.this.getSMDescription(sms.get(0)));
                    String[] names = null;
                    String[] descriptions = null;
                    if (sta.getNumSMs() > 1) {
                        names = new String[sms.size() - 1];
                        descriptions = new String[sms.size() - 1];
                        for (int i = 1; i < sms.size(); ++i) {
                            names[i - 1] = sms.get(i).getSmNodeDesc();
                            descriptions[i - 1] = StatisticsCard.this.getSMDescription(sms.get(i));
                        }
                    }
                    ((StatisticsView)StatisticsCard.this.view).setStandbySMNames(names, descriptions);
                } else {
                    ((StatisticsView)StatisticsCard.this.view).setMsmName(null, null);
                }
                ((StatisticsView)StatisticsCard.this.view).repaint();
            }
        });
    }

    protected String getSMDescription(SMInfoDataBean sm) {
        return STLConstants.K0026_LID.getValue() + ": " + StringUtils.intHexString(sm.getLid()) + " " + STLConstants.K0027_PORT_GUID.getValue() + ": " + StringUtils.longHexString(sm.getSmPortGuid());
    }

    public String getTitle(GroupStatistics sta) {
        return STLConstants.K0007_SUBNET.getValue() + ": " + sta.getName();
    }

    @Override
    public ICardListener getCardListener() {
        return this;
    }

    @Override
    public void clear() {
        this.nodesController.clear();
        this.portsController.clear();
        if (this.viewClearTimer == null) {
            this.viewClearTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (StatisticsCard.this.viewClearTimer != null) {
                        ((StatisticsView)StatisticsCard.this.view).clear();
                    }
                }
            });
            this.viewClearTimer.setRepeats(false);
        }
        this.viewClearTimer.restart();
    }
}

