/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.common.BaseSectionController;
import com.intel.stl.ui.common.ICardController;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HealthHistoryCard;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.StatisticsCard;
import com.intel.stl.ui.main.StatusCard;
import com.intel.stl.ui.main.WorstNodesCard;
import com.intel.stl.ui.main.view.SummarySectionView;
import com.intel.stl.ui.model.GroupStatistics;
import com.intel.stl.ui.model.NodeScore;
import com.intel.stl.ui.model.TimedScore;
import java.util.Date;
import java.util.EnumMap;
import net.engio.mbassy.bus.MBassador;

public class SummarySection
extends BaseSectionController<ISectionListener, SummarySectionView> {
    private final StatisticsCard statisticsCard;
    private final StatusCard statusCard;
    private final HealthHistoryCard healthHistoryCard;
    private final WorstNodesCard worstNodesCard;

    public SummarySection(SummarySectionView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.statisticsCard = new StatisticsCard(view.getStatisticsView(), eventBus);
        this.statusCard = new StatusCard(view.getStatusView(), eventBus);
        this.healthHistoryCard = new HealthHistoryCard(view.getHealthView(), eventBus);
        this.worstNodesCard = new WorstNodesCard(view.getWorstNodesView(), eventBus);
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getSubnetSummary();
    }

    public StatisticsCard getStatisticsCard() {
        return this.statisticsCard;
    }

    public StatusCard getStatusCard() {
        return this.statusCard;
    }

    public HealthHistoryCard getHealthHistoryCard() {
        return this.healthHistoryCard;
    }

    public WorstNodesCard getWorstNodesCard() {
        return this.worstNodesCard;
    }

    @Override
    public ICardController<?>[] getCards() {
        return new ICardController[]{this.statisticsCard, this.statusCard, this.healthHistoryCard, this.worstNodesCard};
    }

    public void updateStatistics(GroupStatistics groupStatistics) {
        this.statisticsCard.updateStatistics(groupStatistics);
    }

    public void updateStates(EnumMap<NoticeSeverity, Integer> swStates, int totalSWs, EnumMap<NoticeSeverity, Integer> caStates, int totalCAs) {
        this.statusCard.updateSwStates(swStates, totalSWs);
        this.statusCard.updateFiStates(caStates, totalCAs);
    }

    public void updateHealthScore(TimedScore score) {
        if (score != null) {
            this.healthHistoryCard.updateHealthScore(score.getScore(), new Date(score.getTime()), score.getTip());
        }
    }

    public void updateWorstNodes(NodeScore[] nodes) {
        this.worstNodesCard.updateWorstNodes(nodes);
    }

    @Override
    public void clear() {
        this.statisticsCard.clear();
        this.statusCard.clear();
        this.healthHistoryCard.clear();
        this.worstNodesCard.clear();
    }

    @Override
    protected ISectionListener getSectionListener() {
        return this;
    }

    public void setContext(Context context) {
        this.healthHistoryCard.setContext(context);
        this.statusCard.setContext(context);
        this.worstNodesCard.setContext(context);
    }
}

