/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.common.BaseSectionController;
import com.intel.stl.ui.common.ICardController;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HealthHistoryCard;
import com.intel.stl.ui.main.NodeStatesCardOld;
import com.intel.stl.ui.main.StatisticsCardOld;
import com.intel.stl.ui.main.WorstNodesCard;
import com.intel.stl.ui.main.view.SummarySectionViewOld;
import com.intel.stl.ui.model.GroupStatistics;
import com.intel.stl.ui.model.NodeScore;
import com.intel.stl.ui.model.TimedScore;
import java.util.Date;
import java.util.EnumMap;
import net.engio.mbassy.bus.MBassador;

public class SummarySectionOld
extends BaseSectionController<ISectionListener, SummarySectionViewOld> {
    private final StatisticsCardOld statisticsCard;
    private final NodeStatesCardOld swStatesCard;
    private final NodeStatesCardOld caStatesCard;
    private final HealthHistoryCard healthHistoryCard;
    private final WorstNodesCard worstNodesCard;

    public SummarySectionOld(SummarySectionViewOld view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.statisticsCard = new StatisticsCardOld(view.getStatisticsView(), eventBus);
        this.swStatesCard = new NodeStatesCardOld(view.getSwStatesPie(), eventBus);
        this.caStatesCard = new NodeStatesCardOld(view.getCaStatesPie(), eventBus);
        this.healthHistoryCard = new HealthHistoryCard(view.getHealthHistoryView(), eventBus);
        this.worstNodesCard = new WorstNodesCard(view.getWorstNodesView(), eventBus);
    }

    public StatisticsCardOld getStatisticsCard() {
        return this.statisticsCard;
    }

    public NodeStatesCardOld getSwStatesCard() {
        return this.swStatesCard;
    }

    public NodeStatesCardOld getCaStatesCard() {
        return this.caStatesCard;
    }

    public HealthHistoryCard getHealthHistoryCard() {
        return this.healthHistoryCard;
    }

    public WorstNodesCard getWorstNodesCard() {
        return this.worstNodesCard;
    }

    @Override
    public ICardController<?>[] getCards() {
        return new ICardController[]{this.statisticsCard, this.swStatesCard, this.caStatesCard, this.healthHistoryCard, this.worstNodesCard};
    }

    public void updateStatistics(GroupStatistics groupStatistics) {
        this.statisticsCard.updateStatistics(groupStatistics);
    }

    public void updateStates(EnumMap<NoticeSeverity, Integer> swStates, int totalSWs, EnumMap<NoticeSeverity, Integer> caStates, int totalCAs) {
        this.swStatesCard.updateStates(swStates, totalSWs);
        this.caStatesCard.updateStates(caStates, totalCAs);
    }

    public void updateHealthScore(TimedScore score) {
        this.healthHistoryCard.updateHealthScore(score.getScore(), new Date(score.getTime()), "");
    }

    public void updateWorstNodes(NodeScore[] nodes) {
        this.worstNodesCard.updateWorstNodes(nodes);
    }

    @Override
    public void clear() {
        this.healthHistoryCard.clear();
    }

    @Override
    protected ISectionListener getSectionListener() {
        return this;
    }
}

