/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.main.UndoableSelection;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoHandler {
    private static final Logger log = LoggerFactory.getLogger(UndoHandler.class);
    private final ExUndoManager undoMgr;
    private final UndoAction undoAction;
    private final RedoAction redoAction;
    private final AtomicBoolean inProgress = new AtomicBoolean(false);

    public UndoHandler() {
        this.undoMgr = new ExUndoManager();
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
    }

    public void addUndoAction(UndoableSelection<?> edit) {
        if (!edit.isValid()) {
            log.warn("Invalid UndoableSelection " + edit);
            return;
        }
        this.undoMgr.addEdit(edit);
        log.info("ADD " + edit);
        this.update();
    }

    public UndoAction getUndoAction() {
        return this.undoAction;
    }

    public RedoAction getRedoAction() {
        return this.redoAction;
    }

    protected void update() {
        this.undoAction.setEnabled(this.undoMgr.hasUndo());
        this.redoAction.setEnabled(this.undoMgr.hasRedo());
    }

    public synchronized boolean isInProgress() {
        return this.inProgress.get();
    }

    class ExUndoManager
    extends UndoManager {
        private static final long serialVersionUID = 7210552571742712837L;

        ExUndoManager() {
        }

        public boolean hasUndo() {
            return this.editToBeUndone() != null;
        }

        public boolean hasRedo() {
            return this.editToBeRedone() != null;
        }
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 7923924627643464462L;

        public RedoAction() {
            super(null, UIImages.REDO.getImageIcon());
            this.setEnabled(false);
            this.putValue("ShortDescription", STLConstants.K1008_REDO.getValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            UndoHandler undoHandler = UndoHandler.this;
            synchronized (undoHandler) {
                UndoHandler.this.inProgress.set(true);
                try {
                    if (UndoHandler.this.undoMgr.canRedo()) {
                        UndoHandler.this.undoMgr.redo();
                    }
                    UndoHandler.this.update();
                }
                finally {
                    UndoHandler.this.inProgress.set(false);
                }
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -4557051992945784935L;

        public UndoAction() {
            super(null, UIImages.UNDO.getImageIcon());
            this.setEnabled(false);
            this.putValue("ShortDescription", STLConstants.K1007_UNDO.getValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            UndoHandler undoHandler = UndoHandler.this;
            synchronized (undoHandler) {
                UndoHandler.this.inProgress.set(true);
                try {
                    if (UndoHandler.this.undoMgr.canUndo()) {
                        UndoHandler.this.undoMgr.undo();
                    }
                    UndoHandler.this.update();
                }
                finally {
                    UndoHandler.this.inProgress.set(false);
                }
            }
        }
    }
}

