/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.main.view.AbstractDataChartRangeUpdater;
import com.intel.stl.ui.main.view.ShiftedNumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;

public class DataChartRangeUpdater
extends AbstractDataChartRangeUpdater {
    @Override
    public TickUnitSource createTickUnits(long upper) {
        long upperOrig = upper * 8L;
        long numberOfTicks = 10L;
        if (upperOrig < 1000L) {
            this.unitStr = STLConstants.K0697_BYTE.getValue();
            this.unitDes = STLConstants.K0697_BYTE.getValue();
            this.tickUnitSize = 0.0;
            return null;
        }
        if (upperOrig < 1000000L) {
            this.unitStr = STLConstants.K0695_KB.getValue();
            this.unitDes = STLConstants.K3308_KB_DESCRIPTION.getValue();
            this.tickUnitSize = 125.0;
        } else if (upperOrig < 1000000000L) {
            this.unitStr = STLConstants.K0722_MB.getValue();
            this.unitDes = STLConstants.K3309_MB_DESCRIPTION.getValue();
            this.tickUnitSize = 125000.0;
        } else {
            this.unitStr = STLConstants.K0696_GB.getValue();
            this.unitDes = STLConstants.K3310_GB_DESCRIPTION.getValue();
            this.tickUnitSize = 1.25E8;
        }
        TickUnits units = new TickUnits();
        double unit = Math.max((double)upper / ((double)numberOfTicks * this.tickUnitSize), 1.0) * this.tickUnitSize;
        units.add((TickUnit)new ShiftedNumberTickUnit(unit, this.tickUnitSize));
        return units;
    }
}

