/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.main.view.IChartStyleListener;
import com.intel.stl.ui.main.view.NodeStatesBar;
import com.intel.stl.ui.main.view.NodeStatesPie;
import com.intel.stl.ui.model.ChartStyle;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jfree.data.general.PieDataset;

public class NodeStatesView
extends JCardView<IChartStyleListener> {
    private static final long serialVersionUID = -8330957415988551326L;
    private JPanel mainPanel;
    private CardLayout layout;
    private NodeStatesBar barPanel;
    private NodeStatesPie piePanel;
    private JButton styleBtn;
    private ChartStyle style = ChartStyle.PIE;
    private ImageIcon barIcon;
    private ImageIcon pieIcon;

    public NodeStatesView(String title) {
        super(title);
        this.getMainComponent();
    }

    @Override
    protected JPanel getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.layout = new CardLayout();
            this.mainPanel.setLayout(this.layout);
            this.barPanel = new NodeStatesBar(false);
            this.barPanel.setOpaque(false);
            this.mainPanel.add((Component)this.barPanel, ChartStyle.BAR.name());
            this.piePanel = new NodeStatesPie(false);
            this.piePanel.setOpaque(false);
            this.mainPanel.add((Component)this.piePanel, ChartStyle.PIE.name());
            this.layout.show(this.mainPanel, ChartStyle.PIE.name());
        }
        return this.mainPanel;
    }

    @Override
    protected void addControlButtons(JToolBar toolBar) {
        this.styleBtn = ComponentFactory.getImageButton(UIImages.BAR_ICON.getImageIcon());
        this.styleBtn.setToolTipText(UILabels.STL40002_TO_BAR.getDescription());
        toolBar.add(this.styleBtn);
        super.addControlButtons(toolBar);
    }

    @Override
    public void setCardListener(final IChartStyleListener listener) {
        super.setCardListener(listener);
        this.styleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.onStyleChange(NodeStatesView.this.style);
            }
        });
    }

    public void setDataset(PieDataset dataset, Color[] colors) {
        this.piePanel.setDataset(dataset, colors);
    }

    public void setStates(double[] values, String[] labels, String[] tooltips) {
        if (this.style == ChartStyle.PIE) {
            this.piePanel.setStates(values, labels, tooltips);
        } else if (this.style == ChartStyle.BAR) {
            this.barPanel.setStates(values, labels, tooltips);
        }
    }

    public void setStyle(ChartStyle style) {
        this.style = style;
        this.layout.show(this.mainPanel, style.name());
        if (style == ChartStyle.BAR) {
            if (this.pieIcon == null) {
                this.pieIcon = UIImages.PIE_ICON.getImageIcon();
            }
            this.styleBtn.setIcon(this.pieIcon);
            this.styleBtn.setToolTipText(UILabels.STL40003_TO_PIE.getDescription());
        } else if (style == ChartStyle.PIE) {
            if (this.barIcon == null) {
                this.barIcon = UIImages.BAR_ICON.getImageIcon();
            }
            this.styleBtn.setIcon(this.barIcon);
            this.styleBtn.setToolTipText(UILabels.STL40002_TO_BAR.getDescription());
        }
    }

    public void clear() {
        this.barPanel.clear();
        this.piePanel.clear();
    }
}

