/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.main.view.AbstractPacketChartRangeUpdater;
import com.intel.stl.ui.main.view.ShiftedNumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;

public class PacketChartRangeUpdater
extends AbstractPacketChartRangeUpdater {
    @Override
    public TickUnitSource createTickUnits(long upper) {
        long tenMultiplier;
        long upperOrig = upper;
        long numOfTicks = 10L;
        for (tenMultiplier = 1L; upper >= 10L && tenMultiplier < 0xCCCCCCCCCCCCCCCL; tenMultiplier *= 10L, upper /= 10L) {
        }
        if (tenMultiplier >= 1000000000L) {
            this.tickUnit = 1000000000L;
            this.unitStr = STLConstants.K3314_GP.getValue();
            this.unitDes = STLConstants.K3317_GP_DESCRIPTION.getValue();
        } else if (tenMultiplier >= 1000000L) {
            this.tickUnit = 1000000L;
            this.unitStr = STLConstants.K3313_MP.getValue();
            this.unitDes = STLConstants.K3316_MP_DESCRIPTION.getValue();
        } else if (tenMultiplier >= 1000L) {
            this.tickUnit = 1000L;
            this.unitStr = STLConstants.K3312_KP.getValue();
            this.unitDes = STLConstants.K3315_KP_DESCRIPTION.getValue();
        } else {
            this.tickUnit = 1L;
            this.unitStr = STLConstants.K3311_PACKETS.getValue();
            this.unitDes = STLConstants.K3311_PACKETS.getValue();
            return null;
        }
        TickUnits units = new TickUnits();
        double unit = Math.max(upperOrig / (numOfTicks * this.tickUnit), 1L) * this.tickUnit;
        units.add((TickUnit)new ShiftedNumberTickUnit(unit, this.tickUnit));
        return units;
    }
}

