/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.main.view.IChartStyleListener;
import com.intel.stl.ui.main.view.NodeStatusPanel;
import com.intel.stl.ui.model.ChartStyle;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jfree.data.general.PieDataset;

public class StatusView
extends JCardView<IChartStyleListener> {
    private static final long serialVersionUID = 8374679365582635122L;
    private JButton styleBtn;
    private ChartStyle style = ChartStyle.PIE;
    private ImageIcon barIcon;
    private ImageIcon pieIcon;
    private JPanel mainPanel;
    private NodeStatusPanel swPanel;
    private NodeStatusPanel fiPanel;

    public StatusView() {
        super(STLConstants.K0062_STATUS.getValue());
        this.getMainComponent();
    }

    protected boolean isConcise() {
        return false;
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            BoxLayout layout = new BoxLayout(this.mainPanel, 1);
            this.mainPanel.setLayout(layout);
            JLabel label = ComponentFactory.getH4Label(STLConstants.K0063_SW_STATUS.getValue(), 1);
            label.setBorder(BorderFactory.createEmptyBorder(2, 15, 0, 0));
            label.setAlignmentX(0.0f);
            this.mainPanel.add(label);
            this.swPanel = new NodeStatusPanel(this.isConcise());
            this.swPanel.setName(WidgetName.HP_STU_SW_DIST.name());
            this.swPanel.setOpaque(false);
            this.swPanel.setAlignmentX(0.0f);
            this.mainPanel.add(this.swPanel);
            label = ComponentFactory.getH4Label(STLConstants.K0064_FI_STATUS.getValue(), 1);
            label.setBorder(BorderFactory.createEmptyBorder(5, 15, 0, 0));
            label.setAlignmentX(0.0f);
            this.mainPanel.add(label);
            this.fiPanel = new NodeStatusPanel(this.isConcise());
            this.fiPanel.setName(WidgetName.HP_STU_HFI_DIST.name());
            this.fiPanel.setOpaque(false);
            this.fiPanel.setAlignmentX(0.0f);
            this.mainPanel.add(this.fiPanel);
            this.styleBtn.setName(WidgetName.HP_STU_CHART_STYLE.name());
            this.setHelpButtonName(WidgetName.HP_STU_HELP.name());
            this.setPinButtonName(WidgetName.HP_STU_PIN.name());
        }
        return this.mainPanel;
    }

    public NodeStatusPanel getSwPanel() {
        return this.swPanel;
    }

    public NodeStatusPanel getFiPanel() {
        return this.fiPanel;
    }

    @Override
    protected void addControlButtons(JToolBar toolBar) {
        this.styleBtn = ComponentFactory.getImageButton(UIImages.BAR_ICON.getImageIcon());
        this.styleBtn.setName(WidgetName.HP_STU_STYLE.name());
        this.styleBtn.setToolTipText(UILabels.STL40002_TO_BAR.getDescription());
        toolBar.add(this.styleBtn);
        super.addControlButtons(toolBar);
    }

    @Override
    public void setCardListener(final IChartStyleListener listener) {
        super.setCardListener(listener);
        if (this.styleBtn != null) {
            this.styleBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    listener.onStyleChange(StatusView.this.style);
                }
            });
        }
    }

    public void setStyle(ChartStyle style) {
        if (this.styleBtn == null) {
            return;
        }
        this.style = style;
        if (style == ChartStyle.BAR) {
            if (this.pieIcon == null) {
                this.pieIcon = UIImages.PIE_ICON.getImageIcon();
            }
            this.styleBtn.setIcon(this.pieIcon);
            this.styleBtn.setToolTipText(UILabels.STL40003_TO_PIE.getDescription());
        } else if (style == ChartStyle.PIE) {
            if (this.barIcon == null) {
                this.barIcon = UIImages.BAR_ICON.getImageIcon();
            }
            this.styleBtn.setIcon(this.barIcon);
            this.styleBtn.setToolTipText(UILabels.STL40002_TO_BAR.getDescription());
        }
    }

    public void setSwDataset(PieDataset dataset, Color[] colors) {
        this.swPanel.setDataset(dataset, colors);
    }

    public void setFiDataset(PieDataset dataset, Color[] colors) {
        this.fiPanel.setDataset(dataset, colors);
    }

    public void setSwStates(double[] values, String[] labels, String[] tooltips) {
        this.swPanel.setStates(values, labels, tooltips);
    }

    public void setFiStates(double[] values, String[] labels, String[] tooltips) {
        this.fiPanel.setStates(values, labels, tooltips);
    }

    public void clear() {
        this.swPanel.clear();
        this.fiPanel.clear();
    }
}

