/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.api.StringUtils;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.event.JumpDestination;
import com.intel.stl.ui.main.view.IWorstNodesListener;
import com.intel.stl.ui.model.NodeScore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.Timer;
import org.jdesktop.swingx.JXHyperlink;

public class WorstNodePopup
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 5839148578351334245L;
    private JLabel header;
    private JPanel contentPanel;
    private JLabel lid;
    private JLabel score;
    private JLabel event;
    private JXHyperlink[] jumpBtns;
    private IWorstNodesListener listener;
    private NodeScore nodeScore;
    private Popup popup;
    private Timer hideTimer;

    public WorstNodePopup() {
        this.initComponent();
        this.addMouseListener(this);
    }

    public void setListener(IWorstNodesListener listener) {
        this.listener = listener;
    }

    protected void initComponent() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BLUE));
        this.header = this.createHeader();
        this.add((Component)this.header, "North");
        this.contentPanel = new JPanel(new GridBagLayout());
        this.contentPanel.setBackground(UIConstants.INTEL_WHITE);
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 4, 0));
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        JLabel label = ComponentFactory.getH5Label(STLConstants.K0026_LID.getValue(), 1);
        label.setHorizontalAlignment(4);
        this.contentPanel.add((Component)label, gc);
        gc.gridwidth = 0;
        gc.weightx = 1.0;
        this.lid = ComponentFactory.getH5Label("", 0);
        this.contentPanel.add((Component)this.lid, gc);
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        label = ComponentFactory.getH5Label(STLConstants.K0108_SCORE.getValue(), 1);
        label.setHorizontalAlignment(4);
        this.contentPanel.add((Component)label, gc);
        gc.gridwidth = 0;
        gc.weightx = 1.0;
        this.score = ComponentFactory.getH5Label("", 1);
        this.contentPanel.add((Component)this.score, gc);
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        label = ComponentFactory.getH5Label(STLConstants.K0674_EVENT_TYPE.getValue(), 1);
        label.setHorizontalAlignment(4);
        this.contentPanel.add((Component)label, gc);
        gc.gridwidth = 0;
        gc.weightx = 1.0;
        this.event = ComponentFactory.getH5Label("", 0);
        this.contentPanel.add((Component)this.event, gc);
        gc.gridwidth = 1;
        gc.gridheight = JumpDestination.values().length;
        gc.weightx = 0.0;
        gc.anchor = 11;
        label = ComponentFactory.getH5Label(STLConstants.K1055_INSPECT.getValue(), 1);
        label.setHorizontalAlignment(4);
        this.contentPanel.add((Component)label, gc);
        gc.weightx = 1.0;
        gc.gridheight = 1;
        gc.gridwidth = 0;
        gc.anchor = 10;
        this.jumpBtns = new JXHyperlink[JumpDestination.values().length];
        for (int i = 0; i < this.jumpBtns.length; ++i) {
            final JumpDestination dest = JumpDestination.values()[i];
            this.jumpBtns[i] = new JXHyperlink((Action)new AbstractAction(dest.getName()){
                private static final long serialVersionUID = 4612692450375442721L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WorstNodePopup.this.nodeScore != null && WorstNodePopup.this.listener != null) {
                        WorstNodePopup.this.listener.jumpTo(WorstNodePopup.this.nodeScore.getLid(), WorstNodePopup.this.nodeScore.getType(), dest);
                        WorstNodePopup.this.hidePopup();
                    }
                }
            });
            this.contentPanel.add((Component)this.jumpBtns[i], gc);
        }
        this.add((Component)this.contentPanel, "Center");
    }

    protected JLabel createHeader() {
        JLabel header = ComponentFactory.getH4Label("", 1);
        header.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, UIConstants.INTEL_ORANGE));
        return header;
    }

    public void setNode(NodeScore nodeScore) {
        if (nodeScore == null) {
            return;
        }
        this.nodeScore = nodeScore;
        this.header.setText(nodeScore.getName());
        this.header.setIcon(nodeScore.getIcon());
        this.lid.setText(StringUtils.intHexString(nodeScore.getLid()));
        this.score.setText(UIConstants.DECIMAL.format(nodeScore.getScore()));
        this.score.setForeground(nodeScore.getColor());
        this.event.setText(nodeScore.getEventType().name());
        for (JXHyperlink btn : this.jumpBtns) {
            btn.setEnabled(nodeScore.isActive());
        }
        this.revalidate();
    }

    public synchronized void setPopup(Popup popup) {
        this.hidePopup();
        this.popup = popup;
    }

    protected synchronized void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.hideTimer != null) {
            if (this.hideTimer.isRunning()) {
                this.hideTimer.stop();
            }
            this.hideTimer = null;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.popup != null && !this.getVisibleRect().contains(e.getPoint())) {
            if (this.hideTimer == null) {
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (WorstNodePopup.this.hideTimer != null) {
                            WorstNodePopup.this.hidePopup();
                        }
                    }
                };
                this.hideTimer = new Timer(500, listener);
                this.hideTimer.setRepeats(false);
            }
            this.hideTimer.restart();
        }
    }
}

