/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.LinkDownReason;
import com.intel.stl.ui.common.STLConstants;
import java.util.HashMap;
import java.util.Map;

public enum LinkDownReasonViz {
    NONE(LinkDownReason.NONE, STLConstants.K0056_NONE.getValue()),
    RCV_ERROR_0(LinkDownReason.RCV_ERROR_0, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 0"),
    BAD_PKT_LEN(LinkDownReason.BAD_PKT_LEN, STLConstants.K0462_BAD_PACKET_LENGTH.getValue()),
    PKT_TOO_LONG(LinkDownReason.PKT_TOO_LONG, STLConstants.K0463_PACKET_TOO_LONG.getValue()),
    PKT_TOO_SHORT(LinkDownReason.PKT_TOO_SHORT, STLConstants.K0464_PACKET_TOO_SHORT.getValue()),
    BAD_SLID(LinkDownReason.BAD_SLID, STLConstants.K0465_BAD_SOURCE_LID.getValue()),
    BAD_DLID(LinkDownReason.BAD_DLID, STLConstants.K0466_BAD_DESTINATION_LID.getValue()),
    BAD_L2(LinkDownReason.BAD_L2, STLConstants.K0467_BAD_L2.getValue()),
    BAD_SC(LinkDownReason.BAD_SC, STLConstants.K0468_BAD_SC.getValue()),
    RCV_ERROR_8(LinkDownReason.RCV_ERROR_8, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 8"),
    BAD_MID_TAIL(LinkDownReason.BAD_MID_TAIL, STLConstants.K0469_BAD_MID_TAIL.getValue()),
    RCV_ERROR_10(LinkDownReason.RCV_ERROR_10, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 10"),
    PREEMPT_ERROR(LinkDownReason.PREEMPT_ERROR, STLConstants.K0477_PREMPT_ERROR.getValue()),
    PREEMPT_VL15(LinkDownReason.PREEMPT_VL15, STLConstants.K0478_PREMPT_VL15.getValue()),
    BAD_VL_MARKER(LinkDownReason.BAD_VL_MARKER, STLConstants.K0470_BAD_VL_MARKER.getValue()),
    RCV_ERROR_14(LinkDownReason.RCV_ERROR_14, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 14"),
    RCV_ERROR_15(LinkDownReason.RCV_ERROR_15, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 15"),
    BAD_HEAD_DIST(LinkDownReason.BAD_HEAD_DIST, STLConstants.K0471_BAD_HEAD_DIST.getValue()),
    BAD_TAIL_DIST(LinkDownReason.BAD_TAIL_DIST, STLConstants.K0472_BAD_TAIL_DIST.getValue()),
    BAD_CTRL_DIST(LinkDownReason.BAD_CTRL_DIST, STLConstants.K0473_BAD_CTRL_DIST.getValue()),
    BAD_CREDIT_ACK(LinkDownReason.BAD_CREDIT_ACK, STLConstants.K0474_BAD_CREDIT_ACK.getValue()),
    UNSUPPORTED_VL_MARKER(LinkDownReason.UNSUPPORTED_VL_MARKER, STLConstants.K0479_UNSUPPORTED_VL_MARKER.getValue()),
    BAD_PREEMPT(LinkDownReason.BAD_PREEMPT, STLConstants.K0475_BAD_PREEMPT.getValue()),
    BAD_CONTROL_FLIT(LinkDownReason.BAD_CONTROL_FLIT, STLConstants.K0476_BAD_CTRL_FLIT.getValue()),
    EXCEED_MULTICAST_LIMIT(LinkDownReason.EXCEED_MULTICAST_LIMIT, STLConstants.K0480_EXCEEDED_MULTICAST_LIMIT.getValue()),
    RCV_ERROR_24(LinkDownReason.RCV_ERROR_24, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 24"),
    RCV_ERROR_25(LinkDownReason.RCV_ERROR_25, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 25"),
    RCV_ERROR_26(LinkDownReason.RCV_ERROR_26, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 26"),
    RCV_ERROR_27(LinkDownReason.RCV_ERROR_27, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 27"),
    RCV_ERROR_28(LinkDownReason.RCV_ERROR_28, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 28"),
    RCV_ERROR_29(LinkDownReason.RCV_ERROR_29, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 29"),
    RCV_ERROR_30(LinkDownReason.RCV_ERROR_30, STLConstants.K0461_RECEIVE_ERROR.getValue() + " 30"),
    EXCESSIVE_BUFFER_OVERRUN(LinkDownReason.EXCESSIVE_BUFFER_OVERRUN, STLConstants.K0481_EXCESSIVE_BUFFER_OVERRUN.getValue()),
    UNKNOWN(LinkDownReason.UNKNOWN, STLConstants.K0016_UNKNOWN.getValue()),
    REBOOT(LinkDownReason.REBOOT, STLConstants.K0482_REBOOT.getValue()),
    NEIGHBOR_UNKNOWN(LinkDownReason.NEIGHBOR_UNKNOWN, STLConstants.K0483_NEIGHBOR_UNKNOWN.getValue()),
    FM_BOUNCE(LinkDownReason.FM_BOUNCE, STLConstants.K0460_FM_BOUNCE.getValue()),
    SPEED_POLICY(LinkDownReason.SPEED_POLICY, STLConstants.K1340_LINKDOWN_SPEED_POLICY.getValue()),
    WIDTH_POLICY(LinkDownReason.WIDTH_POLICY, STLConstants.K1341_LINKDOWN_WIDTH_POLICY.getValue()),
    DISCONNECTED(LinkDownReason.DISCONNECTED, STLConstants.K1349_LINKDOWN_DISCONNECTED.getValue()),
    LOCAL_MEDIA_NOT_INSTALLED(LinkDownReason.LOCAL_MEDIA_NOT_INSTALLED, STLConstants.K1350_LINKDOWN_LOCAL_MEDIA_NOT_INSTALLED.getValue()),
    NOT_INSTALLED(LinkDownReason.NOT_INSTALLED, STLConstants.K1351_LINKDOWN_NOT_INSTALLED.getValue()),
    CHASSIS_CONFIG(LinkDownReason.CHASSIS_CONFIG, STLConstants.K1352_LINKDOWN_CHASSIS_CONFIG.getValue()),
    END_TO_END_NOT_INSTALLED(LinkDownReason.END_TO_END_NOT_INSTALLED, STLConstants.K1354_LINKDOWN_END_TO_END_NOT_INSTALLED.getValue()),
    POWER_POLICY(LinkDownReason.POWER_POLICY, STLConstants.K1356_LINKDOWN_POWER_POLICY.getValue()),
    LINKSPEED_POLICY(LinkDownReason.LINKSPEED_POLICY, STLConstants.K1357_LINKDOWN_LINKSPEED_POLICY.getValue()),
    LINKWIDTH_POLICY(LinkDownReason.LINKWIDTH_POLICY, STLConstants.K1358_LINKDOWN_LINKWIDTH_POLICY.getValue()),
    SWITCH_MGMT(LinkDownReason.SWITCH_MGMT, STLConstants.K1360_LINKDOWN_SWITCH_MGMT.getValue()),
    SMA_DISABLED(LinkDownReason.SMA_DISABLED, STLConstants.K1361_LINKDOWN_SMA_DISABLED.getValue()),
    TRANSIENT(LinkDownReason.TRANSIENT, STLConstants.K1363_LINKDOWN_TRANSIENT.getValue());

    private static final Map<Byte, String> linkDownReasonMap;
    private final LinkDownReason reason;
    private final String value;

    private LinkDownReasonViz(LinkDownReason reason, String value) {
        this.reason = reason;
        this.value = value;
    }

    public LinkDownReason getReason() {
        return this.reason;
    }

    public String getValue() {
        return this.value;
    }

    public static String getLinkDownReasonStr(byte reason) {
        return linkDownReasonMap.get(reason);
    }

    static {
        linkDownReasonMap = new HashMap<Byte, String>();
        for (LinkDownReasonViz ldrv : LinkDownReasonViz.values()) {
            linkDownReasonMap.put(ldrv.reason.getCode(), ldrv.value);
        }
    }
}

