/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import java.awt.Color;
import java.util.EnumMap;

public final class NoticeSeverityViz
extends Enum<NoticeSeverityViz> {
    public static final /* enum */ NoticeSeverityViz CRITICAL;
    public static final /* enum */ NoticeSeverityViz ERROR;
    public static final /* enum */ NoticeSeverityViz WARNING;
    public static final /* enum */ NoticeSeverityViz INFO;
    public static final String[] names;
    public static final Color[] colors;
    private final NoticeSeverity severity;
    private final String name;
    private final Color color;
    private final UIImages icon;
    private static final /* synthetic */ NoticeSeverityViz[] $VALUES;

    public static NoticeSeverityViz[] values() {
        return (NoticeSeverityViz[])$VALUES.clone();
    }

    public static NoticeSeverityViz valueOf(String name) {
        return Enum.valueOf(NoticeSeverityViz.class, name);
    }

    private NoticeSeverityViz(NoticeSeverity severity, String name, Color color, UIImages icon) {
        this.severity = severity;
        this.name = name;
        this.color = color;
        this.icon = icon;
    }

    public NoticeSeverity getSeverity() {
        return this.severity;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public UIImages getIcon() {
        return this.icon;
    }

    public static int[] getDistributionValues(EnumMap<NoticeSeverity, Integer> counts) {
        NoticeSeverityViz[] all = NoticeSeverityViz.values();
        int[] res = new int[all.length];
        for (int i = 0; i < all.length; ++i) {
            Integer val = counts.get((Object)all[i].severity);
            res[i] = val == null ? 0 : val;
        }
        return res;
    }

    public static NoticeSeverity getNoticeSeverityFor(String name) {
        NoticeSeverityViz[] all = NoticeSeverityViz.values();
        for (int i = 0; i < all.length; ++i) {
            if (!all[i].getName().equals(name)) continue;
            return all[i].getSeverity();
        }
        return null;
    }

    public static NoticeSeverityViz getNoticeSeverityVizFor(NoticeSeverity type) {
        NoticeSeverityViz[] values = NoticeSeverityViz.values();
        for (int i = 0; i < values.length; ++i) {
            if (type != values[i].getSeverity()) continue;
            return values[i];
        }
        return null;
    }

    static {
        int i;
        CRITICAL = new NoticeSeverityViz(NoticeSeverity.CRITICAL, STLConstants.K0029_CRITICAL.getValue(), UIConstants.INTEL_RED, UIImages.CRITICAL_ICON);
        ERROR = new NoticeSeverityViz(NoticeSeverity.ERROR, STLConstants.K0030_ERROR.getValue(), UIConstants.INTEL_ORANGE, UIImages.ERROR_ICON);
        WARNING = new NoticeSeverityViz(NoticeSeverity.WARNING, STLConstants.K0031_WARNING.getValue(), UIConstants.INTEL_YELLOW, UIImages.WARNING_ICON);
        INFO = new NoticeSeverityViz(NoticeSeverity.INFO, STLConstants.K0032_INFORMATIONAL.getValue(), UIConstants.INTEL_GREEN, UIImages.INFORMATION_ICON);
        $VALUES = new NoticeSeverityViz[]{CRITICAL, ERROR, WARNING, INFO};
        names = new String[NoticeSeverityViz.values().length];
        for (i = 0; i < names.length; ++i) {
            NoticeSeverityViz.names[i] = NoticeSeverityViz.values()[i].name;
        }
        colors = new Color[NoticeSeverityViz.values().length];
        for (i = 0; i < colors.length; ++i) {
            NoticeSeverityViz.colors[i] = NoticeSeverityViz.values()[i].color;
        }
    }
}

