/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.PortLinkMode;
import com.intel.stl.ui.common.STLConstants;
import java.util.EnumMap;

public enum PortLinkModeViz {
    NOP(PortLinkMode.NOP, STLConstants.K0118_NOOP.getValue()),
    ETH(PortLinkMode.ETH, STLConstants.K0119_EHT.getValue()),
    STL(PortLinkMode.STL, STLConstants.K0120_STL.getValue());

    private static final EnumMap<PortLinkMode, String> portLinkModeMap;
    private final PortLinkMode portLinkMode;
    private final String value;

    private PortLinkModeViz(PortLinkMode portLinkMode, String value) {
        this.portLinkMode = portLinkMode;
        this.value = value;
    }

    public static String getPortLinkModeStr(PortLinkMode mode) {
        return portLinkModeMap.get((Object)mode);
    }

    public static String getPortLinkModeStr(byte mode) {
        PortLinkMode[] modes = PortLinkMode.getPortLinkModes(mode);
        String comma = "";
        StringBuffer linkModeStr = new StringBuffer();
        for (int i = 0; i < modes.length; ++i) {
            linkModeStr.append(comma);
            linkModeStr.append(portLinkModeMap.get((Object)modes[i]));
            comma = ", ";
        }
        return linkModeStr.toString();
    }

    static {
        portLinkModeMap = new EnumMap(PortLinkMode.class);
        for (PortLinkModeViz plmv : PortLinkModeViz.values()) {
            portLinkModeMap.put(plmv.portLinkMode, plmv.value);
        }
    }
}

