/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.PacketFormat;
import com.intel.stl.api.configuration.PortLinkMode;
import java.util.EnumMap;

public enum PortPacketFormatViz {
    NOP(PacketFormat.NOP, "NOP"),
    FORMAT_8B(PacketFormat.FORMAT_8B, "8B"),
    FORMAT_9B(PacketFormat.FORMAT_9B, "9B"),
    FORMAT_10B(PacketFormat.FORMAT_10B, "10B"),
    FORMAT_16B(PacketFormat.FORMAT_16B, "16B");

    private static final EnumMap<PacketFormat, String> packetFormatMap;
    private final PacketFormat packetFormat;
    private final String value;

    private PortPacketFormatViz(PacketFormat packetFormat, String value) {
        this.packetFormat = packetFormat;
        this.value = value;
    }

    public static String getPortPacketFormatStr(PortLinkMode mode) {
        return packetFormatMap.get((Object)mode);
    }

    public static String getPortPacketFormatStr(short format) {
        PacketFormat[] modes = PacketFormat.getPacketFormats(format);
        String comma = "";
        StringBuffer linkModeStr = new StringBuffer();
        for (int i = 0; i < modes.length; ++i) {
            linkModeStr.append(comma);
            linkModeStr.append(packetFormatMap.get((Object)modes[i]));
            comma = ", ";
        }
        return linkModeStr.toString();
    }

    static {
        packetFormatMap = new EnumMap(PacketFormat.class);
        for (PortPacketFormatViz ppfv : PortPacketFormatViz.values()) {
            packetFormatMap.put(ppfv.packetFormat, ppfv.value);
        }
    }
}

